/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage.queues;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.neo4j.cloud.storage.StorageUtils;
import org.neo4j.cloud.storage.queues.RequestQueue;
import org.neo4j.cloud.storage.queues.RequestQueueConfigs;

public abstract class PushQueue
extends RequestQueue
implements Runnable {
    public static final int QUEUE_SIZE = 64;

    protected PushQueue(RequestQueueConfigs.QueueConfig queueConfig, long objectSize, long startPosition) {
        super(queueConfig, objectSize, startPosition);
    }

    protected abstract void onData(ByteBuffer var1);

    protected abstract void onError(Exception var1);

    @Override
    public void run() {
        this.fillQueue();
        try {
            CompletableFuture<ByteBuffer> response;
            while ((response = this.poll(true)) != null) {
                this.onData(response.get());
            }
        }
        catch (Exception ex) {
            this.onError(StorageUtils.toIOException(ex, () -> "Unable to get the next chunk of data: " + String.valueOf(this)));
        }
    }
}

