/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.Set;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreFileChannel;

public class PathBasedOutputStream
extends OutputStream {
    private final Path path;
    private State state = State.OPEN;
    private OutputStream output;

    public PathBasedOutputStream(Path path) {
        this.path = Objects.requireNonNull(path);
    }

    public void replicate(ThrowingConsumer<Path, IOException> writeOp) throws IOException {
        this.checkNotClosed();
        if (this.state == State.WRITING) {
            throw new IOException("Already written to the path: " + String.valueOf(this.path));
        }
        this.state = State.REPLICATING;
        writeOp.accept((Object)this.path);
    }

    @Override
    public void write(int b) throws IOException {
        this.setupWriting().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.setupWriting().write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (this.state == State.CLOSED) {
            return;
        }
        this.state = State.CLOSED;
        if (this.output != null) {
            this.output.close();
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.state == State.CLOSED) {
            throw new IOException("Stream is already closed");
        }
    }

    private OutputStream setupWriting() throws IOException {
        this.checkNotClosed();
        if (this.state == State.REPLICATING) {
            throw new IOException("Stream has already been replicated to the path: " + String.valueOf(this.path));
        }
        if (this.output == null) {
            this.state = State.WRITING;
            this.output = FileUtils.toBufferedStream((Path)this.path, StoreFileChannel::new, Set.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE));
        }
        return this.output;
    }

    private static enum State {
        OPEN,
        REPLICATING,
        WRITING,
        CLOSED;

    }
}

