/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage.queues;

import java.util.Objects;
import org.neo4j.cloud.storage.StoragePath;
import org.neo4j.cloud.storage.StorageSettingsDeclaration;
import org.neo4j.cloud.storage.StorageSystemProvider;
import org.neo4j.configuration.Config;
import org.neo4j.io.ByteUnit;
import org.neo4j.util.Preconditions;

public record RequestQueueConfigs(QueueConfig pushConfig, QueueConfig pullConfig) {
    public static final int SAMPLING_PULL_QUEUE_SIZE = 1;
    public static final int SAMPLING_PULL_QUEUE_CHUNK_SIZE = (int)(ByteUnit.mebiBytes((long)2L) + ByteUnit.kibiBytes((long)100L));

    public RequestQueueConfigs {
        Objects.requireNonNull(pushConfig);
        Objects.requireNonNull(pullConfig);
    }

    public static RequestQueueConfigs create(StoragePath path) {
        return new RequestQueueConfigs(RequestQueueConfigs.pushQueueConfig(path), RequestQueueConfigs.pullQueueConfig(path, RequestQueueConfigs.isForSampling(path)));
    }

    private static boolean isForSampling(StoragePath path) {
        return path.metadata().getOrDefault((Object)"cloud.storage.read.sampling", (Object)Boolean.FALSE) == Boolean.TRUE;
    }

    private static QueueConfig pushQueueConfig(StoragePath path) {
        Config config = StorageSystemProvider.config(path);
        return new QueueConfig((Integer)config.get(StorageSettingsDeclaration.pushQueueSlotSize(path)), Math.toIntExact((Long)config.get(StorageSettingsDeclaration.pushQueueChunkSize(path))));
    }

    private static QueueConfig pullQueueConfig(StoragePath path, boolean isForSampling) {
        Config config = StorageSystemProvider.config(path);
        if (isForSampling) {
            return new QueueConfig(1, SAMPLING_PULL_QUEUE_CHUNK_SIZE);
        }
        return new QueueConfig((Integer)config.get(StorageSettingsDeclaration.pullQueueSlotSize(path)), Math.toIntExact((Long)config.get(StorageSettingsDeclaration.pullQueueChunkSize(path))));
    }

    public record QueueConfig(int queueSize, int chunkSize) {
        public QueueConfig {
            Preconditions.requirePositive((int)queueSize);
            Preconditions.requirePositive((int)chunkSize);
        }
    }
}

