/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cloud.storage;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.set.MutableSet;
import org.neo4j.cloud.storage.StorageChannel;
import org.neo4j.cloud.storage.StoragePath;
import org.neo4j.cloud.storage.StorageSchemeResolver;
import org.neo4j.cloud.storage.StorageSystemProvider;
import org.neo4j.cloud.storage.StorageSystemProviderFactory;
import org.neo4j.cloud.storage.StorageUtils;
import org.neo4j.configuration.Config;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.service.Services;

public class SchemeFileSystemAbstraction
implements FileSystemAbstraction,
StorageSchemeResolver {
    private final MutableMap<String, StorageSystemProvider> schemesToProvider = Maps.mutable.empty();
    private final FileSystemAbstraction fs;
    private final Collection<StorageSystemProviderFactory> factories;
    private final Config config;
    private final InternalLogProvider logProvider;
    private final MemoryTracker memoryTracker;

    public SchemeFileSystemAbstraction(FileSystemAbstraction fs) {
        this(fs, Config.defaults());
    }

    public SchemeFileSystemAbstraction(FileSystemAbstraction fs, Config config) {
        this(fs, config, (InternalLogProvider)NullLogProvider.getInstance(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public SchemeFileSystemAbstraction(FileSystemAbstraction fs, Config config, InternalLogProvider logProvider) {
        this(fs, config, logProvider, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    public SchemeFileSystemAbstraction(FileSystemAbstraction fs, Config config, InternalLogProvider logProvider, MemoryTracker memoryTracker) {
        this(fs, Services.loadAll(StorageSystemProviderFactory.class), config, logProvider, memoryTracker);
    }

    public SchemeFileSystemAbstraction(FileSystemAbstraction fs, Collection<StorageSystemProviderFactory> providerFactories, Config config, InternalLogProvider logProvider, MemoryTracker memoryTracker) {
        this.fs = Objects.requireNonNull(fs);
        this.factories = Objects.requireNonNull(providerFactories);
        this.config = Objects.requireNonNull(config);
        this.logProvider = Objects.requireNonNull(logProvider);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
    }

    @Override
    public Set<String> resolvableSchemes() {
        MutableSet schemes = Sets.mutable.of((Object[])new String[]{"file"});
        for (StorageSystemProviderFactory factory : this.factories) {
            schemes.add((Object)factory.scheme());
        }
        return schemes.asUnmodifiable();
    }

    @Override
    public boolean canResolve(URI resource) {
        return this.internalCanResolve(resource.getScheme());
    }

    @Override
    public boolean canResolve(String resource) {
        Matcher matcher = SCHEME.matcher(resource);
        if (matcher.matches()) {
            return this.internalCanResolve(matcher.group(1));
        }
        return true;
    }

    @Override
    public Path resolve(URI resource) throws IOException {
        return this.internalResolve(resource.getScheme(), () -> resource);
    }

    @Override
    public Path resolve(String resource) throws IOException {
        Matcher matcher = SCHEME.matcher(resource);
        if (matcher.matches()) {
            return this.internalResolve(matcher.group(1), () -> URI.create(resource));
        }
        return Path.of(resource, new String[0]);
    }

    public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
        if (fileName instanceof StoragePath) {
            StoragePath path = (StoragePath)fileName;
            return this.internalOpen(path, options);
        }
        return this.fs.open(fileName, options);
    }

    public StoreChannel write(Path fileName) throws IOException {
        if (fileName instanceof StoragePath) {
            StoragePath path = (StoragePath)fileName;
            return this.internalOpen(path, StorageUtils.WRITE_OPTIONS);
        }
        return this.fs.write(fileName);
    }

    public StoreChannel read(Path fileName) throws IOException {
        if (fileName instanceof StoragePath) {
            StoragePath path = (StoragePath)fileName;
            return this.internalOpen(path, StorageUtils.READ_OPTIONS);
        }
        return this.fs.read(fileName);
    }

    public OutputStream openAsOutputStream(Path fileName, boolean append, int bufferSize, boolean autoFlush) throws IOException {
        if (fileName instanceof StoragePath) {
            StoragePath path = (StoragePath)fileName;
            Set<OpenOption> options = append ? StorageUtils.APPEND_OPTIONS : StorageUtils.WRITE_OPTIONS;
            return SchemeFileSystemAbstraction.provider(path).newOutputStream(fileName, (OpenOption[])options.toArray(OpenOption[]::new));
        }
        return this.fs.openAsOutputStream(fileName, append, bufferSize, autoFlush);
    }

    public InputStream openAsInputStream(Path fileName) throws IOException {
        if (fileName instanceof StoragePath) {
            StoragePath path = (StoragePath)fileName;
            return SchemeFileSystemAbstraction.provider(path).newInputStream(path, new OpenOption[0]);
        }
        return this.fs.openAsInputStream(fileName);
    }

    public void truncate(Path file, long size) throws IOException {
        if (file instanceof StoragePath) {
            StoragePath path = (StoragePath)file;
            try (SeekableByteChannel channel = SchemeFileSystemAbstraction.provider(path).newByteChannel(path, StorageUtils.WRITE_OPTIONS);){
                channel.truncate(size);
            }
        } else {
            this.fs.truncate(file, size);
        }
    }

    public boolean fileExists(Path file) {
        return this.fs.fileExists(file) || StoragePath.isStorageDir(file);
    }

    public void mkdir(Path fileName) throws IOException {
        this.fs.mkdir(fileName);
    }

    public void mkdirs(Path fileName) throws IOException {
        this.fs.mkdirs(fileName);
    }

    public long getFileSize(Path fileName) throws IOException {
        return this.fs.getFileSize(fileName);
    }

    public long getBlockSize(Path file) throws IOException {
        if (file instanceof StoragePath) {
            StoragePath path = (StoragePath)file;
            throw new IOException("StoragePaths do not have access to the remote system's block size: " + String.valueOf(path));
        }
        return this.fs.getBlockSize(file);
    }

    public void delete(Path path) throws IOException {
        this.fs.delete(path);
    }

    public void deleteFile(Path fileName) throws IOException {
        this.fs.deleteFile(fileName);
    }

    public void deleteRecursively(Path directory) throws IOException {
        this.fs.deleteRecursively(directory);
    }

    public void deleteRecursively(Path directory, Predicate<Path> removeFilePredicate) throws IOException {
        this.fs.deleteRecursively(directory, removeFilePredicate);
    }

    public void renameFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.fs.renameFile(from, to, copyOptions);
    }

    public Path[] listFiles(Path directory) throws IOException {
        return this.fs.listFiles(directory);
    }

    public Path[] listFiles(Path directory, DirectoryStream.Filter<Path> filter) throws IOException {
        return this.fs.listFiles(directory, filter);
    }

    public boolean isDirectory(Path file) {
        return this.fs.isDirectory(file);
    }

    public void moveToDirectory(Path file, Path toDirectory) throws IOException {
        this.fs.moveToDirectory(file, toDirectory);
    }

    public void copyToDirectory(Path file, Path toDirectory) throws IOException {
        this.fs.copyToDirectory(file, toDirectory);
    }

    public void copyFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        this.fs.copyFile(from, to, copyOptions);
    }

    public void copyRecursively(Path fromDirectory, Path toDirectory) throws IOException {
        this.fs.copyRecursively(fromDirectory, toDirectory);
    }

    public long lastModifiedTime(Path file) throws IOException {
        return this.fs.lastModifiedTime(file);
    }

    public void deleteFileOrThrow(Path file) throws IOException {
        this.fs.deleteFileOrThrow(file);
    }

    public int getFileDescriptor(StoreChannel channel) {
        return this.fs.getFileDescriptor(channel);
    }

    public Path createTempFile(String prefix, String suffix) throws IOException {
        return this.fs.createTempFile(prefix, suffix);
    }

    public Path createTempFile(Path dir, String prefix, String suffix) throws IOException {
        return this.fs.createTempFile(dir, prefix, suffix);
    }

    public Path createTempDirectory(String prefix) throws IOException {
        return this.fs.createTempDirectory(prefix);
    }

    public Path createTempDirectory(Path dir, String prefix) throws IOException {
        return this.fs.createTempDirectory(dir, prefix);
    }

    public boolean isPersistent() {
        return !this.factories.isEmpty() || this.fs.isPersistent();
    }

    public FileWatcher fileWatcher() {
        throw new UnsupportedOperationException("fileWatcher not implemented");
    }

    public void close() throws IOException {
        try {
            IOUtils.closeAll((Iterable)this.schemesToProvider.values());
        }
        finally {
            this.schemesToProvider.clear();
        }
    }

    private boolean internalCanResolve(String scheme) {
        if (scheme == null || "file".equalsIgnoreCase(scheme)) {
            return true;
        }
        for (StorageSystemProviderFactory factory : this.factories) {
            if (!factory.matches(scheme)) continue;
            return true;
        }
        return false;
    }

    private Path internalResolve(String scheme, Supplier<URI> resource) throws IOException {
        if (scheme == null || "file".equalsIgnoreCase(scheme)) {
            return Path.of(resource.get());
        }
        String schemeToResolve = scheme.toLowerCase(Locale.ROOT);
        for (StorageSystemProviderFactory factory : this.factories) {
            if (!factory.matches(schemeToResolve)) continue;
            try {
                StorageSystemProvider provider = (StorageSystemProvider)this.schemesToProvider.getIfAbsentPut((Object)schemeToResolve, (Function0 & Serializable)() -> factory.createStorageSystemProvider(prefix -> this.tempChannel(prefix, schemeToResolve), this.config, this.logProvider, this.memoryTracker, ClassLoader.getSystemClassLoader()));
                URI uri = resource.get();
                provider.getStorageSystem(uri);
                return provider.getPath(uri);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }
        throw new ProviderMismatchException("No storage system found for scheme: " + scheme);
    }

    private StorageSystemProviderFactory.ChunkChannel tempChannel(String prefix, String scheme) throws IOException {
        final Path path = this.fs.createTempFile(prefix, scheme);
        final StoreChannel channel = this.fs.write(path);
        return new StorageSystemProviderFactory.ChunkChannel(){

            @Override
            public Path path() {
                return path;
            }

            @Override
            public void write(ByteBuffer buffer) throws IOException {
                channel.writeAll(buffer);
            }

            @Override
            public void close() throws IOException {
                try {
                    channel.close();
                }
                finally {
                    SchemeFileSystemAbstraction.this.fs.delete(path);
                }
            }
        };
    }

    private StoreChannel internalOpen(StoragePath path, Set<OpenOption> options) throws IOException {
        return new StorageChannel(SchemeFileSystemAbstraction.provider(path).newByteChannel(path, options));
    }

    private static StorageSystemProvider provider(StoragePath path) {
        return path.getFileSystem().provider();
    }
}

