/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.neo4j.causalclustering.core.state.ClusterStateDirectory;
import org.neo4j.causalclustering.core.state.ClusterStateException;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.dbms.CannotWriteException;
import org.neo4j.commandline.dbms.StoreLockChecker;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.server.configuration.ConfigLoader;

public class UnbindFromClusterCommand
implements AdminCommand {
    private static final Arguments arguments = new Arguments().withDatabase();
    private Path homeDir;
    private Path configDir;
    private OutsideWorld outsideWorld;

    UnbindFromClusterCommand(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        this.homeDir = homeDir;
        this.configDir = configDir;
        this.outsideWorld = outsideWorld;
    }

    static Arguments arguments() {
        return arguments;
    }

    private static Config loadNeo4jConfig(Path homeDir, Path configDir, String databaseName) {
        ConfigLoader configLoader = new ConfigLoader(UnbindFromClusterCommand.settings());
        Config config = configLoader.loadConfig(Optional.of(homeDir.toFile()), Optional.of(configDir.resolve("neo4j.conf").toFile()), new Pair[0]);
        HashMap<String, String> additionalConfig = new HashMap<String, String>();
        additionalConfig.put(DatabaseManagementSystemSettings.active_database.name(), databaseName);
        return config.with(additionalConfig, new Class[0]);
    }

    private static List<Class<?>> settings() {
        return Arrays.asList(GraphDatabaseSettings.class, DatabaseManagementSystemSettings.class);
    }

    public void execute(String[] args) throws IncorrectUsage, CommandFailed {
        try {
            Config config = UnbindFromClusterCommand.loadNeo4jConfig(this.homeDir, this.configDir, arguments.parse(args).get("database"));
            File dataDirectory = (File)config.get(DatabaseManagementSystemSettings.data_directory);
            Path pathToSpecificDatabase = ((File)config.get(DatabaseManagementSystemSettings.database_path)).toPath();
            Validators.CONTAINS_EXISTING_DATABASE.validate((Object)pathToSpecificDatabase.toFile());
            this.confirmTargetDirectoryIsWritable(pathToSpecificDatabase);
            ClusterStateDirectory clusterStateDirectory = new ClusterStateDirectory(dataDirectory);
            clusterStateDirectory.initialize(this.outsideWorld.fileSystem());
            this.deleteClusterStateIn(clusterStateDirectory.get().toPath());
        }
        catch (StoreLockException e) {
            throw new CommandFailed("Database is currently locked. Please shutdown Neo4j.", (Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            throw new IncorrectUsage(e.getMessage());
        }
        catch (IOException | CannotWriteException | UnbindFailureException e) {
            throw new CommandFailed("Unbind failed: " + e.getMessage(), (Exception)e);
        }
        catch (ClusterStateException e) {
            throw new CommandFailed((Throwable)e);
        }
    }

    private void confirmTargetDirectoryIsWritable(Path pathToSpecificDatabase) throws CommandFailed, CannotWriteException, IOException {
        new StoreLockChecker().withLock(pathToSpecificDatabase).close();
    }

    private void deleteClusterStateIn(Path target) throws UnbindFailureException {
        try {
            FileUtils.deleteRecursively((File)target.toFile());
        }
        catch (IOException e) {
            throw new UnbindFailureException(e);
        }
    }

    private class UnbindFailureException
    extends Exception {
        UnbindFailureException(Exception e) {
            super(e);
        }
    }
}

