/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.util.List;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.storageengine.api.ReadableChannel;

public class RaftMessageDecoder
extends ByteToMessageDecoder {
    private final ChannelMarshal<ReplicatedContent> marshal;

    public RaftMessageDecoder(ChannelMarshal<ReplicatedContent> marshal) {
        this.marshal = marshal;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> list) throws Exception {
        RaftMessages.BaseRaftMessage result;
        NetworkReadableClosableChannelNetty4 channel = new NetworkReadableClosableChannelNetty4(buffer);
        ClusterId clusterId = (ClusterId)ClusterId.Marshal.INSTANCE.unmarshal((ReadableChannel)channel);
        int messageTypeWire = channel.getInt();
        RaftMessages.Type[] values = RaftMessages.Type.values();
        RaftMessages.Type messageType = values[messageTypeWire];
        MemberId from = this.retrieveMember((ReadableChannel)channel);
        if (messageType.equals((Object)RaftMessages.Type.VOTE_REQUEST)) {
            MemberId candidate = this.retrieveMember((ReadableChannel)channel);
            long term = channel.getLong();
            long lastLogIndex = channel.getLong();
            long lastLogTerm = channel.getLong();
            result = new RaftMessages.Vote.Request(from, term, candidate, lastLogIndex, lastLogTerm);
        } else if (messageType.equals((Object)RaftMessages.Type.VOTE_RESPONSE)) {
            long term = channel.getLong();
            boolean voteGranted = channel.get() == 1;
            result = new RaftMessages.Vote.Response(from, term, voteGranted);
        } else if (messageType.equals((Object)RaftMessages.Type.APPEND_ENTRIES_REQUEST)) {
            long term = channel.getLong();
            long prevLogIndex = channel.getLong();
            long prevLogTerm = channel.getLong();
            long leaderCommit = channel.getLong();
            long count = channel.getLong();
            RaftLogEntry[] entries = new RaftLogEntry[(int)count];
            int i = 0;
            while ((long)i < count) {
                long entryTerm = channel.getLong();
                ReplicatedContent content = this.marshal.unmarshal((ReadableChannel)channel);
                entries[i] = new RaftLogEntry(entryTerm, content);
                ++i;
            }
            result = new RaftMessages.AppendEntries.Request(from, term, prevLogIndex, prevLogTerm, entries, leaderCommit);
        } else if (messageType.equals((Object)RaftMessages.Type.APPEND_ENTRIES_RESPONSE)) {
            long term = channel.getLong();
            boolean success = channel.get() == 1;
            long matchIndex = channel.getLong();
            long appendIndex = channel.getLong();
            result = new RaftMessages.AppendEntries.Response(from, term, success, matchIndex, appendIndex);
        } else if (messageType.equals((Object)RaftMessages.Type.NEW_ENTRY_REQUEST)) {
            ReplicatedContent content = this.marshal.unmarshal((ReadableChannel)channel);
            result = new RaftMessages.NewEntry.Request(from, content);
        } else if (messageType.equals((Object)RaftMessages.Type.HEARTBEAT)) {
            long leaderTerm = channel.getLong();
            long commitIndexTerm = channel.getLong();
            long commitIndex = channel.getLong();
            result = new RaftMessages.Heartbeat(from, leaderTerm, commitIndex, commitIndexTerm);
        } else if (messageType.equals((Object)RaftMessages.Type.HEARTBEAT_RESPONSE)) {
            result = new RaftMessages.HeartbeatResponse(from);
        } else if (messageType.equals((Object)RaftMessages.Type.LOG_COMPACTION_INFO)) {
            long leaderTerm = channel.getLong();
            long prevIndex = channel.getLong();
            result = new RaftMessages.LogCompactionInfo(from, leaderTerm, prevIndex);
        } else {
            throw new IllegalArgumentException("Unknown message type");
        }
        list.add(new RaftMessages.ClusterIdAwareMessage(clusterId, result));
    }

    private MemberId retrieveMember(ReadableChannel buffer) throws IOException, EndOfStreamException {
        MemberId.Marshal memberIdMarshal = new MemberId.Marshal();
        return (MemberId)memberIdMarshal.unmarshal(buffer);
    }
}

