/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastClient;
import org.neo4j.causalclustering.discovery.HazelcastClientConnector;
import org.neo4j.causalclustering.discovery.HazelcastCoreTopologyService;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.LogProvider;

public class HazelcastDiscoveryServiceFactory
implements DiscoveryServiceFactory {
    @Override
    public CoreTopologyService coreTopologyService(Config config, MemberId myself, JobScheduler jobScheduler, LogProvider logProvider, LogProvider userLogProvider) {
        HazelcastDiscoveryServiceFactory.configureHazelcast(config);
        return new HazelcastCoreTopologyService(config, myself, jobScheduler, logProvider, userLogProvider);
    }

    @Override
    public TopologyService readReplicaDiscoveryService(Config config, LogProvider logProvider, JobScheduler jobScheduler) {
        HazelcastDiscoveryServiceFactory.configureHazelcast(config);
        return new HazelcastClient(new HazelcastClientConnector(config), jobScheduler, logProvider, config);
    }

    private static void configureHazelcast(Config config) {
        System.setProperty("hazelcast.phone.home.enabled", "false");
        if (((Boolean)config.get(CausalClusteringSettings.disable_middleware_logging)).booleanValue()) {
            System.setProperty("hazelcast.logging.type", "none");
        }
    }
}

