/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import com.hazelcast.config.Config;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.spi.properties.GroupProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.CoreTopologyListenerService;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.HazelcastClusterTopology;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.helper.RobustJobSchedulerWrapper;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class HazelcastCoreTopologyService
extends LifecycleAdapter
implements CoreTopologyService {
    private static final long HAZELCAST_IS_HEALTHY_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(10L);
    private final org.neo4j.kernel.configuration.Config config;
    private final MemberId myself;
    private final Log log;
    private final Log userLog;
    private final CoreTopologyListenerService listenerService;
    private final RobustJobSchedulerWrapper scheduler;
    private final long refreshPeriod;
    private String membershipRegistrationId;
    private JobScheduler.JobHandle refreshJob;
    private HazelcastInstance hazelcastInstance;
    private volatile ReadReplicaTopology readReplicaTopology = ReadReplicaTopology.EMPTY;
    private volatile CoreTopology coreTopology = CoreTopology.EMPTY;
    private volatile Map<MemberId, AdvertisedSocketAddress> catchupAddressMap = new HashMap<MemberId, AdvertisedSocketAddress>();

    HazelcastCoreTopologyService(org.neo4j.kernel.configuration.Config config, MemberId myself, JobScheduler jobScheduler, LogProvider logProvider, LogProvider userLogProvider) {
        this.config = config;
        this.myself = myself;
        this.listenerService = new CoreTopologyListenerService();
        this.log = logProvider.getLog(this.getClass());
        this.scheduler = new RobustJobSchedulerWrapper(jobScheduler, this.log);
        this.userLog = userLogProvider.getLog(this.getClass());
        this.refreshPeriod = (Long)config.get(CausalClusteringSettings.cluster_topology_refresh);
    }

    @Override
    public void addCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listenerService.addCoreTopologyListener(listener);
        listener.onCoreTopologyChange(this.coreTopology);
    }

    @Override
    public boolean setClusterId(ClusterId clusterId) {
        return HazelcastClusterTopology.casClusterId(this.hazelcastInstance, clusterId);
    }

    public void start() {
        this.log.info("Cluster discovery service started");
        this.hazelcastInstance = this.createHazelcastInstance();
        this.membershipRegistrationId = this.hazelcastInstance.getCluster().addMembershipListener((MembershipListener)new OurMembershipListener());
        this.refreshJob = this.scheduler.scheduleRecurring("TopologyRefresh", this.refreshPeriod, (ThrowingAction<Exception>)((ThrowingAction)this::refreshTopology));
    }

    public void stop() {
        this.log.info(String.format("HazelcastCoreTopologyService stopping and unbinding from %s", this.config.get(CausalClusteringSettings.discovery_listen_address)));
        this.scheduler.cancelAndWaitTermination(this.refreshJob);
        try {
            this.hazelcastInstance.getCluster().removeMembershipListener(this.membershipRegistrationId);
            this.hazelcastInstance.getLifecycleService().terminate();
        }
        catch (Throwable e) {
            this.log.warn("Failed to stop Hazelcast", e);
        }
    }

    private HazelcastInstance createHazelcastInstance() {
        System.setProperty(GroupProperty.WAIT_SECONDS_BEFORE_JOIN.getName(), "1");
        JoinConfig joinConfig = new JoinConfig();
        joinConfig.getMulticastConfig().setEnabled(false);
        joinConfig.getAwsConfig().setEnabled(false);
        TcpIpConfig tcpIpConfig = joinConfig.getTcpIpConfig();
        tcpIpConfig.setEnabled(true);
        List initialMembers = (List)this.config.get(CausalClusteringSettings.initial_discovery_members);
        for (AdvertisedSocketAddress address : initialMembers) {
            tcpIpConfig.addMember(address.toString());
        }
        Setting<ListenSocketAddress> discovery_listen_address = CausalClusteringSettings.discovery_listen_address;
        ListenSocketAddress hazelcastAddress = (ListenSocketAddress)this.config.get(discovery_listen_address);
        InterfacesConfig interfaces = new InterfacesConfig();
        interfaces.addInterface(hazelcastAddress.getHostname());
        NetworkConfig networkConfig = new NetworkConfig();
        networkConfig.setInterfaces(interfaces);
        networkConfig.setPort(hazelcastAddress.getPort());
        networkConfig.setJoin(joinConfig);
        networkConfig.setPortAutoIncrement(false);
        Config c = new Config();
        c.setProperty(GroupProperty.OPERATION_CALL_TIMEOUT_MILLIS.getName(), String.valueOf(10000));
        c.setProperty(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS.getName(), "10");
        c.setProperty(GroupProperty.MERGE_FIRST_RUN_DELAY_SECONDS.getName(), "10");
        c.setProperty(GroupProperty.INITIAL_MIN_CLUSTER_SIZE.getName(), String.valueOf(this.minimumClusterSizeThatCanTolerateOneFaultForExpectedClusterSize()));
        c.setProperty(GroupProperty.LOGGING_TYPE.getName(), "none");
        c.setNetworkConfig(networkConfig);
        MemberAttributeConfig memberAttributeConfig = HazelcastClusterTopology.buildMemberAttributes(this.myself, this.config);
        c.setMemberAttributeConfig(memberAttributeConfig);
        this.logConnectionInfo(initialMembers);
        JobScheduler.JobHandle logJob = this.scheduler.schedule("HazelcastHealth", HAZELCAST_IS_HEALTHY_TIMEOUT_MS, (ThrowingAction<Exception>)((ThrowingAction)() -> this.log.warn("The server has not been able to connect in a timely fashion to the cluster. Please consult the logs for more details. Rebooting the server may solve the problem.")));
        try {
            this.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)c);
            logJob.cancel(true);
        }
        catch (HazelcastException e) {
            String errorMessage = String.format("Hazelcast was unable to start with setting: %s = %s", discovery_listen_address.name(), this.config.get(discovery_listen_address));
            this.userLog.error(errorMessage);
            this.log.error(errorMessage, (Throwable)e);
            throw new RuntimeException(e);
        }
        return this.hazelcastInstance;
    }

    private void logConnectionInfo(List<AdvertisedSocketAddress> initialMembers) {
        this.userLog.info("My connection info: [\n\tDiscovery:   listen=%s, advertised=%s,\n\tTransaction: listen=%s, advertised=%s, \n\tRaft:        listen=%s, advertised=%s, \n\tClient Connector Addresses: %s\n]", new Object[]{this.config.get(CausalClusteringSettings.discovery_listen_address), this.config.get(CausalClusteringSettings.discovery_advertised_address), this.config.get(CausalClusteringSettings.transaction_listen_address), this.config.get(CausalClusteringSettings.transaction_advertised_address), this.config.get(CausalClusteringSettings.raft_listen_address), this.config.get(CausalClusteringSettings.raft_advertised_address), ClientConnectorAddresses.extractFromConfig(this.config)});
        this.userLog.info("Discovering cluster with initial members: " + initialMembers);
        this.userLog.info("Attempting to connect to the other cluster members before continuing...");
    }

    private Integer minimumClusterSizeThatCanTolerateOneFaultForExpectedClusterSize() {
        return (Integer)this.config.get(CausalClusteringSettings.expected_core_cluster_size) / 2 + 1;
    }

    @Override
    public CoreTopology coreServers() {
        return this.coreTopology;
    }

    @Override
    public ReadReplicaTopology readReplicas() {
        return this.readReplicaTopology;
    }

    @Override
    public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId memberId) {
        return Optional.ofNullable(this.catchupAddressMap.get(memberId));
    }

    private synchronized void refreshTopology() {
        this.refreshCoreTopology();
        this.refreshReadReplicaTopology();
        this.catchupAddressMap = HazelcastClusterTopology.extractCatchupAddressesMap(this.coreTopology, this.readReplicaTopology);
    }

    private void refreshCoreTopology() {
        this.coreTopology = HazelcastClusterTopology.getCoreTopology(this.hazelcastInstance, this.config, this.log);
        this.listenerService.notifyListeners(this.coreTopology);
    }

    private void refreshReadReplicaTopology() {
        this.readReplicaTopology = HazelcastClusterTopology.getReadReplicaTopology(this.hazelcastInstance, this.log);
        this.log.info("Current read replica topology is %s", new Object[]{this.readReplicaTopology});
    }

    private class OurMembershipListener
    implements MembershipListener {
        private OurMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            HazelcastCoreTopologyService.this.log.info("Core member added %s", new Object[]{membershipEvent});
            HazelcastCoreTopologyService.this.refreshTopology();
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            HazelcastCoreTopologyService.this.log.info("Core member removed %s", new Object[]{membershipEvent});
            HazelcastCoreTopologyService.this.refreshTopology();
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            HazelcastCoreTopologyService.this.log.info("Core member attribute changed %s", new Object[]{memberAttributeEvent});
        }
    }
}

