/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ClientConnectorSettings;

public class ClientConnectorAddresses
implements Iterable<ConnectorUri> {
    private final List<ConnectorUri> connectorUris;

    public ClientConnectorAddresses(List<ConnectorUri> connectorUris) {
        this.connectorUris = connectorUris;
    }

    static ClientConnectorAddresses extractFromConfig(Config config) {
        ArrayList<ConnectorUri> connectorUris = new ArrayList<ConnectorUri>();
        connectorUris.add(new ConnectorUri(Scheme.bolt, GraphDatabaseSettings.boltConnectors((Config)config).stream().findFirst().map(boltConnector -> (AdvertisedSocketAddress)config.get(boltConnector.advertised_address)).orElseThrow(() -> new IllegalArgumentException("A Bolt connector must be configured to run a cluster"))));
        ClientConnectorSettings.httpConnector((Config)config, (ClientConnectorSettings.HttpConnector.Encryption)ClientConnectorSettings.HttpConnector.Encryption.NONE).map(connector -> (AdvertisedSocketAddress)config.get(connector.advertised_address)).ifPresent(httpsAddress -> connectorUris.add(new ConnectorUri(Scheme.http, (AdvertisedSocketAddress)httpsAddress)));
        ClientConnectorSettings.httpConnector((Config)config, (ClientConnectorSettings.HttpConnector.Encryption)ClientConnectorSettings.HttpConnector.Encryption.TLS).map(connector -> (AdvertisedSocketAddress)config.get(connector.advertised_address)).ifPresent(httpsAddress -> connectorUris.add(new ConnectorUri(Scheme.https, (AdvertisedSocketAddress)httpsAddress)));
        return new ClientConnectorAddresses(connectorUris);
    }

    public AdvertisedSocketAddress getBoltAddress() {
        return this.connectorUris.stream().filter(connectorUri -> ((ConnectorUri)connectorUri).scheme == Scheme.bolt).findFirst().orElseThrow(() -> new IllegalArgumentException("A Bolt connector must be configured to run a cluster")).socketAddress;
    }

    public List<URI> uriList() {
        return this.connectorUris.stream().map(rec$ -> ((ConnectorUri)rec$).toUri()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientConnectorAddresses that = (ClientConnectorAddresses)o;
        return Objects.equals(this.connectorUris, that.connectorUris);
    }

    public int hashCode() {
        return Objects.hash(this.connectorUris);
    }

    public String toString() {
        return this.connectorUris.stream().map(ConnectorUri::toString).collect(Collectors.joining(","));
    }

    static ClientConnectorAddresses fromString(String value) {
        return new ClientConnectorAddresses(Stream.of(value.split(",")).map(x$0 -> ConnectorUri.fromString(x$0)).collect(Collectors.toList()));
    }

    @Override
    public Iterator<ConnectorUri> iterator() {
        return this.connectorUris.iterator();
    }

    public static class ConnectorUri {
        private final Scheme scheme;
        private final AdvertisedSocketAddress socketAddress;

        public ConnectorUri(Scheme scheme, AdvertisedSocketAddress socketAddress) {
            this.scheme = scheme;
            this.socketAddress = socketAddress;
        }

        private URI toUri() {
            try {
                return new URI(this.scheme.name().toLowerCase(), null, this.socketAddress.getHostname(), this.socketAddress.getPort(), null, null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public String toString() {
            return this.toUri().toString();
        }

        private static ConnectorUri fromString(String string) {
            URI uri = URI.create(string);
            return new ConnectorUri(Scheme.valueOf(uri.getScheme()), new AdvertisedSocketAddress(uri.getHost(), uri.getPort()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectorUri that = (ConnectorUri)o;
            return this.scheme == that.scheme && Objects.equals(this.socketAddress, that.socketAddress);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.scheme, this.socketAddress});
        }
    }

    public static enum Scheme {
        bolt,
        http,
        https;

    }
}

