/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdGenerator;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdRangeAcquirer;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.logging.LogProvider;

class SwitchableRaftIdGenerator
implements IdGenerator {
    private final IdType idType;
    private final ReplicatedIdRangeAcquirer acquirer;
    private final LogProvider logProvider;
    private volatile IdGenerator delegate;

    SwitchableRaftIdGenerator(IdGenerator initialDelegate, IdType idType, ReplicatedIdRangeAcquirer acquirer, LogProvider logProvider) {
        this.delegate = initialDelegate;
        this.idType = idType;
        this.acquirer = acquirer;
        this.logProvider = logProvider;
    }

    void switchToRaft() {
        long highId = this.delegate.getHighId();
        this.delegate.close();
        this.delegate = new ReplicatedIdGenerator(this.idType, highId, this.acquirer, this.logProvider);
    }

    public IdRange nextIdBatch(int size) {
        return this.delegate.nextIdBatch(size);
    }

    public long nextId() {
        return this.delegate.nextId();
    }

    public long getHighId() {
        return this.delegate.getHighId();
    }

    public void setHighId(long id) {
        this.delegate.setHighId(id);
    }

    public long getHighestPossibleIdInUse() {
        return this.delegate.getHighestPossibleIdInUse();
    }

    public void freeId(long id) {
        this.delegate.freeId(id);
    }

    public void close() {
        this.delegate.close();
    }

    public long getNumberOfIdsInUse() {
        return this.delegate.getNumberOfIdsInUse();
    }

    public long getDefragCount() {
        return this.delegate.getDefragCount();
    }

    public void delete() {
        this.delegate.delete();
    }
}

