/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdRangeAcquirer;
import org.neo4j.causalclustering.core.state.machines.id.SwitchableRaftIdGenerator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorImpl;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfiguration;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.LogProvider;

public class ReplicatedIdGeneratorFactory
extends LifecycleAdapter
implements IdGeneratorFactory {
    private final Map<IdType, SwitchableRaftIdGenerator> generators = new HashMap<IdType, SwitchableRaftIdGenerator>();
    private final FileSystemAbstraction fs;
    private final ReplicatedIdRangeAcquirer idRangeAcquirer;
    private final LogProvider logProvider;
    private IdTypeConfigurationProvider idTypeConfigurationProvider;
    private boolean replicatedMode = false;

    public ReplicatedIdGeneratorFactory(FileSystemAbstraction fs, ReplicatedIdRangeAcquirer idRangeAcquirer, LogProvider logProvider, IdTypeConfigurationProvider idTypeConfigurationProvider) {
        this.fs = fs;
        this.idRangeAcquirer = idRangeAcquirer;
        this.logProvider = logProvider;
        this.idTypeConfigurationProvider = idTypeConfigurationProvider;
    }

    public IdGenerator open(File filename, IdType idType, long highId, long maxId) {
        IdTypeConfiguration idTypeConfiguration = this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
        return this.openGenerator(filename, idTypeConfiguration.getGrabSize(), idType, highId, maxId, idTypeConfiguration.allowAggressiveReuse());
    }

    public IdGenerator open(File fileName, int grabSize, IdType idType, long highId, long maxId) {
        IdTypeConfiguration idTypeConfiguration = this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
        boolean aggressiveReuse = idTypeConfiguration.allowAggressiveReuse();
        return this.openGenerator(fileName, grabSize, idType, highId, maxId, aggressiveReuse);
    }

    private IdGenerator openGenerator(File fileName, int grabSize, IdType idType, long highId, long maxId, boolean aggressiveReuse) {
        SwitchableRaftIdGenerator previous = this.generators.remove(idType);
        if (previous != null) {
            previous.close();
        }
        IdGeneratorImpl initialIdGenerator = new IdGeneratorImpl(this.fs, fileName, grabSize, maxId, aggressiveReuse, highId);
        SwitchableRaftIdGenerator switchableIdGenerator = new SwitchableRaftIdGenerator((IdGenerator)initialIdGenerator, idType, this.idRangeAcquirer, this.logProvider);
        if (this.replicatedMode) {
            switchableIdGenerator.switchToRaft();
        }
        this.generators.put(idType, switchableIdGenerator);
        return switchableIdGenerator;
    }

    public IdGenerator get(IdType idType) {
        return this.generators.get(idType);
    }

    public void create(File fileName, long highId, boolean throwIfFileExists) {
        IdGeneratorImpl.createGenerator((FileSystemAbstraction)this.fs, (File)fileName, (long)highId, (boolean)throwIfFileExists);
    }

    public void start() throws Throwable {
        this.replicatedMode = true;
        for (SwitchableRaftIdGenerator switchableRaftIdGenerator : this.generators.values()) {
            switchableRaftIdGenerator.switchToRaft();
        }
    }
}

