/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.StateMachine;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.kernel.impl.store.id.IdType;

public class ReplicatedIdAllocationStateMachine
implements StateMachine<ReplicatedIdAllocationRequest> {
    private final StateStorage<IdAllocationState> storage;
    private IdAllocationState state;

    public ReplicatedIdAllocationStateMachine(StateStorage<IdAllocationState> storage) {
        this.storage = storage;
    }

    @Override
    public synchronized void applyCommand(ReplicatedIdAllocationRequest request, long commandIndex, Consumer<Result> callback) {
        boolean requestAccepted;
        if (commandIndex <= this.state().logIndex()) {
            return;
        }
        this.state().logIndex(commandIndex);
        IdType idType = request.idType();
        boolean bl = requestAccepted = request.idRangeStart() == this.firstUnallocated(idType);
        if (requestAccepted) {
            this.state().firstUnallocated(idType, request.idRangeStart() + (long)request.idRangeLength());
        }
        callback.accept(Result.of(requestAccepted));
    }

    synchronized long firstUnallocated(IdType idType) {
        return this.state().firstUnallocated(idType);
    }

    @Override
    public void flush() throws IOException {
        this.storage.persistStoreData(this.state());
    }

    @Override
    public long lastAppliedIndex() {
        return this.state().logIndex();
    }

    private IdAllocationState state() {
        if (this.state == null) {
            this.state = this.storage.getInitialState();
        }
        return this.state;
    }

    public synchronized IdAllocationState snapshot() {
        return this.state().newInstance();
    }

    public synchronized void installSnapshot(IdAllocationState snapshot) {
        this.state = snapshot;
    }
}

