/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.vote;

import java.io.IOException;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class VoteState {
    private MemberId votedFor;
    private long term = -1L;

    public VoteState() {
    }

    private VoteState(MemberId votedFor, long term) {
        this.term = term;
        this.votedFor = votedFor;
    }

    public MemberId votedFor() {
        return this.votedFor;
    }

    public boolean update(MemberId votedFor, long term) {
        if (this.termChanged(term)) {
            this.votedFor = votedFor;
            this.term = term;
            return true;
        }
        if (this.votedFor == null) {
            if (votedFor != null) {
                this.votedFor = votedFor;
                return true;
            }
        } else if (!this.votedFor.equals(votedFor)) {
            throw new IllegalArgumentException("Can only vote once per term.");
        }
        return false;
    }

    private boolean termChanged(long term) {
        return term != this.term;
    }

    public long term() {
        return this.term;
    }

    public String toString() {
        return "VoteState{votedFor=" + this.votedFor + ", term=" + this.term + '}';
    }

    public static class Marshal
    extends SafeStateMarshal<VoteState> {
        private final ChannelMarshal<MemberId> memberMarshal;

        public Marshal(ChannelMarshal<MemberId> memberMarshal) {
            this.memberMarshal = memberMarshal;
        }

        @Override
        public void marshal(VoteState state, WritableChannel channel) throws IOException {
            channel.putLong(state.term);
            this.memberMarshal.marshal(state.votedFor(), channel);
        }

        @Override
        public VoteState unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
            long term = channel.getLong();
            MemberId member = this.memberMarshal.unmarshal(channel);
            return new VoteState(member, term);
        }

        @Override
        public VoteState startState() {
            return new VoteState();
        }

        @Override
        public long ordinal(VoteState state) {
            return state.term();
        }
    }
}

