/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import java.util.List;
import org.neo4j.causalclustering.core.consensus.Followers;
import org.neo4j.causalclustering.core.consensus.MajorityIncludingSelfQuorum;
import org.neo4j.causalclustering.core.consensus.RaftMessageHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.outcome.ShipCommand;
import org.neo4j.causalclustering.core.consensus.roles.Appending;
import org.neo4j.causalclustering.core.consensus.roles.Heart;
import org.neo4j.causalclustering.core.consensus.roles.Pruning;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.roles.Voting;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerState;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerStates;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.collection.FilteringIterable;
import org.neo4j.logging.Log;

public class Leader
implements RaftMessageHandler {
    private static Iterable<MemberId> replicationTargets(ReadableRaftState ctx) {
        return new FilteringIterable(ctx.replicationMembers(), member -> !member.equals(ctx.myself()));
    }

    static void sendHeartbeats(ReadableRaftState ctx, Outcome outcome) throws IOException {
        long commitIndex = ctx.commitIndex();
        long commitIndexTerm = ctx.entryLog().readEntryTerm(commitIndex);
        RaftMessages.Heartbeat heartbeat = new RaftMessages.Heartbeat(ctx.myself(), ctx.term(), commitIndex, commitIndexTerm);
        for (MemberId to : Leader.replicationTargets(ctx)) {
            outcome.addOutgoingMessage(new RaftMessages.Directed(to, heartbeat));
        }
    }

    @Override
    public Outcome handle(RaftMessages.RaftMessage message, ReadableRaftState ctx, Log log) throws IOException {
        Outcome outcome = new Outcome(Role.LEADER, ctx);
        switch (message.type()) {
            case HEARTBEAT: {
                RaftMessages.Heartbeat req = (RaftMessages.Heartbeat)message;
                if (req.leaderTerm() < ctx.term()) break;
                this.stepDownToFollower(outcome);
                log.info("Moving to FOLLOWER state after receiving heartbeat at term %d (my term is %d) from %s", new Object[]{req.leaderTerm(), ctx.term(), req.from()});
                Heart.beat(ctx, outcome, (RaftMessages.Heartbeat)message, log);
                break;
            }
            case HEARTBEAT_TIMEOUT: {
                Leader.sendHeartbeats(ctx, outcome);
                break;
            }
            case HEARTBEAT_RESPONSE: {
                outcome.addHeartbeatResponse(message.from());
                break;
            }
            case ELECTION_TIMEOUT: {
                if (!MajorityIncludingSelfQuorum.isQuorum(ctx.votingMembers().size(), ctx.heartbeatResponses().size())) {
                    this.stepDownToFollower(outcome);
                    log.info("Moving to FOLLOWER state after not receiving heartbeat responses in this election timeout period. Heartbeats received: %s", new Object[]{ctx.heartbeatResponses()});
                }
                outcome.getHeartbeatResponses().clear();
                break;
            }
            case APPEND_ENTRIES_REQUEST: {
                RaftMessages.AppendEntries.Request req = (RaftMessages.AppendEntries.Request)message;
                if (req.leaderTerm() < ctx.term()) {
                    RaftMessages.AppendEntries.Response appendResponse = new RaftMessages.AppendEntries.Response(ctx.myself(), ctx.term(), false, -1L, ctx.entryLog().appendIndex());
                    outcome.addOutgoingMessage(new RaftMessages.Directed(req.from(), appendResponse));
                    break;
                }
                if (req.leaderTerm() == ctx.term()) {
                    throw new IllegalStateException("Two leaders in the same term.");
                }
                this.stepDownToFollower(outcome);
                log.info("Moving to FOLLOWER state after receiving append request at term %d (my term is %d) from %s", new Object[]{req.leaderTerm(), ctx.term(), req.from()});
                Appending.handleAppendEntriesRequest(ctx, outcome, req, log);
                break;
            }
            case APPEND_ENTRIES_RESPONSE: {
                RaftMessages.AppendEntries.Response response = (RaftMessages.AppendEntries.Response)message;
                if (response.term() < ctx.term()) break;
                if (response.term() > ctx.term()) {
                    outcome.setNextTerm(response.term());
                    this.stepDownToFollower(outcome);
                    log.info("Moving to FOLLOWER state after receiving append response at term %d (my term is %d) from %s", new Object[]{response.term(), ctx.term(), response.from()});
                    outcome.replaceFollowerStates(new FollowerStates<MemberId>());
                    break;
                }
                FollowerState follower = ctx.followerStates().get(response.from());
                if (response.success()) {
                    long quorumAppendIndex;
                    boolean matchInCurrentTerm;
                    assert (response.matchIndex() <= ctx.entryLog().appendIndex());
                    boolean followerProgressed = response.matchIndex() > follower.getMatchIndex();
                    outcome.replaceFollowerStates(outcome.getFollowerStates().onSuccessResponse(response.from(), Math.max(response.matchIndex(), follower.getMatchIndex())));
                    outcome.addShipCommand(new ShipCommand.Match(response.matchIndex(), response.from()));
                    boolean bl = matchInCurrentTerm = ctx.entryLog().readEntryTerm(response.matchIndex()) == ctx.term();
                    if (!followerProgressed || !matchInCurrentTerm || (quorumAppendIndex = Followers.quorumAppendIndex(ctx.votingMembers(), outcome.getFollowerStates())) <= ctx.commitIndex()) break;
                    outcome.setLeaderCommit(quorumAppendIndex);
                    outcome.setCommitIndex(quorumAppendIndex);
                    outcome.addShipCommand(new ShipCommand.CommitUpdate());
                    break;
                }
                if (response.appendIndex() > -1L && response.appendIndex() >= ctx.entryLog().prevIndex()) {
                    outcome.addShipCommand(new ShipCommand.Mismatch(response.appendIndex(), response.from()));
                    break;
                }
                RaftMessages.LogCompactionInfo compactionInfo = new RaftMessages.LogCompactionInfo(ctx.myself(), ctx.term(), ctx.entryLog().prevIndex());
                RaftMessages.Directed directedCompactionInfo = new RaftMessages.Directed(response.from(), compactionInfo);
                outcome.addOutgoingMessage(directedCompactionInfo);
                break;
            }
            case VOTE_REQUEST: {
                RaftMessages.Vote.Request req = (RaftMessages.Vote.Request)message;
                if (req.term() > ctx.term()) {
                    this.stepDownToFollower(outcome);
                    log.info("Moving to FOLLOWER state after receiving vote request at term %d (my term is %d) from %s", new Object[]{req.term(), ctx.term(), req.from()});
                    Voting.handleVoteRequest(ctx, outcome, req);
                    break;
                }
                outcome.addOutgoingMessage(new RaftMessages.Directed(req.from(), new RaftMessages.Vote.Response(ctx.myself(), ctx.term(), false)));
                break;
            }
            case NEW_ENTRY_REQUEST: {
                RaftMessages.NewEntry.Request req = (RaftMessages.NewEntry.Request)message;
                ReplicatedContent content = req.content();
                Appending.appendNewEntry(ctx, outcome, content);
                break;
            }
            case NEW_BATCH_REQUEST: {
                RaftMessages.NewEntry.BatchRequest req = (RaftMessages.NewEntry.BatchRequest)message;
                List<ReplicatedContent> contents = req.contents();
                Appending.appendNewEntries(ctx, outcome, contents);
                break;
            }
            case PRUNE_REQUEST: {
                Pruning.handlePruneRequest(outcome, (RaftMessages.PruneRequest)message);
                break;
            }
        }
        return outcome;
    }

    private void stepDownToFollower(Outcome outcome) {
        outcome.steppingDown();
        outcome.setNextRole(Role.FOLLOWER);
        outcome.setLeader(null);
    }
}

