/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.RaftMessageHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Appending;
import org.neo4j.causalclustering.core.consensus.roles.Election;
import org.neo4j.causalclustering.core.consensus.roles.Heart;
import org.neo4j.causalclustering.core.consensus.roles.Pruning;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.roles.Voting;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.logging.Log;

class Follower
implements RaftMessageHandler {
    Follower() {
    }

    static boolean logHistoryMatches(ReadableRaftState ctx, long leaderSegmentPrevIndex, long leaderSegmentPrevTerm, Log log) throws IOException {
        long localLogPrevIndex = ctx.entryLog().prevIndex();
        long localSegmentPrevTerm = ctx.entryLog().readEntryTerm(leaderSegmentPrevIndex);
        boolean logHistoryMatches = leaderSegmentPrevIndex > -1L && (leaderSegmentPrevIndex <= localLogPrevIndex || localSegmentPrevTerm == leaderSegmentPrevTerm);
        return logHistoryMatches;
    }

    static void commitToLogOnUpdate(ReadableRaftState ctx, long indexOfLastNewEntry, long leaderCommit, Outcome outcome) {
        long newCommitIndex = Long.min(leaderCommit, indexOfLastNewEntry);
        if (newCommitIndex > ctx.commitIndex()) {
            outcome.setCommitIndex(newCommitIndex);
        }
    }

    private static void handleLeaderLogCompaction(ReadableRaftState ctx, Outcome outcome, RaftMessages.LogCompactionInfo compactionInfo) {
        if (compactionInfo.leaderTerm() < ctx.term()) {
            return;
        }
        if (ctx.entryLog().appendIndex() <= -1L || compactionInfo.prevIndex() > ctx.entryLog().appendIndex()) {
            outcome.markNeedForFreshSnapshot();
        }
    }

    @Override
    public Outcome handle(RaftMessages.RaftMessage message, ReadableRaftState ctx, Log log) throws IOException {
        Outcome outcome = new Outcome(Role.FOLLOWER, ctx);
        switch (message.type()) {
            case HEARTBEAT: {
                Heart.beat(ctx, outcome, (RaftMessages.Heartbeat)message, log);
                break;
            }
            case APPEND_ENTRIES_REQUEST: {
                Appending.handleAppendEntriesRequest(ctx, outcome, (RaftMessages.AppendEntries.Request)message, log);
                break;
            }
            case VOTE_REQUEST: {
                Voting.handleVoteRequest(ctx, outcome, (RaftMessages.Vote.Request)message);
                break;
            }
            case LOG_COMPACTION_INFO: {
                Follower.handleLeaderLogCompaction(ctx, outcome, (RaftMessages.LogCompactionInfo)message);
                break;
            }
            case ELECTION_TIMEOUT: {
                log.info("Election timeout triggered");
                if (!Election.start(ctx, outcome, log)) break;
                outcome.setNextRole(Role.CANDIDATE);
                log.info("Moving to CANDIDATE state after successfully starting election");
                break;
            }
            case PRUNE_REQUEST: {
                Pruning.handlePruneRequest(outcome, (RaftMessages.PruneRequest)message);
                break;
            }
        }
        return outcome;
    }
}

