/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.outcome;

import java.io.IOException;
import java.util.Objects;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.segmented.InFlightMap;
import org.neo4j.causalclustering.core.consensus.outcome.RaftLogCommand;
import org.neo4j.logging.Log;

public class PruneLogCommand
implements RaftLogCommand {
    private final long pruneIndex;

    public PruneLogCommand(long pruneIndex) {
        this.pruneIndex = pruneIndex;
    }

    @Override
    public void dispatch(RaftLogCommand.Handler handler) throws IOException {
        handler.prune(this.pruneIndex);
    }

    @Override
    public void applyTo(RaftLog raftLog, Log log) throws IOException {
        raftLog.prune(this.pruneIndex);
    }

    @Override
    public void applyTo(InFlightMap<RaftLogEntry> inFlightMap, Log log) throws IOException {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PruneLogCommand that = (PruneLogCommand)o;
        return this.pruneIndex == that.pruneIndex;
    }

    public int hashCode() {
        return Objects.hash(this.pruneIndex);
    }

    public String toString() {
        return "PruneLogCommand{pruneIndex=" + this.pruneIndex + '}';
    }
}

