/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.neo4j.causalclustering.core.consensus.log.segmented.DisposedException;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.log.segmented.OpenEndRangeMap;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReaderPool;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentFile;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentHeader;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class Segments
implements AutoCloseable {
    private final OpenEndRangeMap<Long, SegmentFile> rangeMap = new OpenEndRangeMap();
    private final List<SegmentFile> allSegments;
    private final Log log;
    private FileSystemAbstraction fileSystem;
    private final FileNames fileNames;
    private final ChannelMarshal<ReplicatedContent> contentMarshal;
    private final LogProvider logProvider;
    private long currentVersion;
    private final ReaderPool readerPool;

    Segments(FileSystemAbstraction fileSystem, FileNames fileNames, ReaderPool readerPool, List<SegmentFile> allSegments, ChannelMarshal<ReplicatedContent> contentMarshal, LogProvider logProvider, long currentVersion) {
        this.fileSystem = fileSystem;
        this.fileNames = fileNames;
        this.allSegments = new ArrayList<SegmentFile>(allSegments);
        this.contentMarshal = contentMarshal;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
        this.currentVersion = currentVersion;
        this.readerPool = readerPool;
        this.populateRangeMap();
    }

    private void populateRangeMap() {
        for (SegmentFile segment : this.allSegments) {
            this.rangeMap.replaceFrom(segment.header().prevIndex() + 1L, segment);
        }
    }

    synchronized SegmentFile truncate(long prevFileLastIndex, long prevIndex, long prevTerm) throws IOException {
        if (prevFileLastIndex < prevIndex) {
            throw new IllegalArgumentException(String.format("Cannot truncate at index %d which is after current append index %d", prevIndex, prevFileLastIndex));
        }
        if (prevFileLastIndex == prevIndex) {
            this.log.warn(String.format("Truncating at current log append index %d", prevIndex));
        }
        return this.createNext(prevFileLastIndex, prevIndex, prevTerm);
    }

    synchronized SegmentFile rotate(long prevFileLastIndex, long prevIndex, long prevTerm) throws IOException {
        if (prevFileLastIndex != prevIndex) {
            throw new IllegalArgumentException(String.format("Cannot rotate file and have append index go from %d to %d. Going backwards is a truncation operation, going forwards is a skip operation.", prevFileLastIndex, prevIndex));
        }
        return this.createNext(prevFileLastIndex, prevIndex, prevTerm);
    }

    synchronized SegmentFile skip(long prevFileLastIndex, long prevIndex, long prevTerm) throws IOException {
        if (prevFileLastIndex > prevIndex) {
            throw new IllegalArgumentException(String.format("Cannot skip from index %d backwards to index %d", prevFileLastIndex, prevIndex));
        }
        if (prevFileLastIndex == prevIndex) {
            this.log.warn(String.format("Skipping at current log append index %d", prevIndex));
        }
        return this.createNext(prevFileLastIndex, prevIndex, prevTerm);
    }

    private synchronized SegmentFile createNext(long prevFileLastIndex, long prevIndex, long prevTerm) throws IOException {
        ++this.currentVersion;
        SegmentHeader header = new SegmentHeader(prevFileLastIndex, this.currentVersion, prevIndex, prevTerm);
        File file = this.fileNames.getForVersion(this.currentVersion);
        SegmentFile segment = SegmentFile.create(this.fileSystem, file, this.readerPool, this.currentVersion, this.contentMarshal, this.logProvider, header);
        segment.flush();
        this.allSegments.add(segment);
        this.rangeMap.replaceFrom(prevIndex + 1L, segment);
        return segment;
    }

    synchronized OpenEndRangeMap.ValueRange<Long, SegmentFile> getForIndex(long logIndex) {
        return this.rangeMap.lookup(logIndex);
    }

    synchronized SegmentFile last() {
        return this.rangeMap.last();
    }

    public synchronized SegmentFile prune(long pruneIndex) {
        SegmentFile current;
        Iterator<SegmentFile> itr = this.allSegments.iterator();
        SegmentFile notDisposed = itr.next();
        int firstRemaining = 0;
        while (itr.hasNext() && (current = itr.next()).header().prevFileLastIndex() <= pruneIndex && notDisposed.tryClose()) {
            this.log.info("Pruning %s", new Object[]{notDisposed});
            if (!notDisposed.delete()) {
                this.log.error("Failed to delete %s", new Object[]{notDisposed});
                break;
            }
            ++firstRemaining;
            notDisposed = current;
        }
        this.rangeMap.remove(notDisposed.header().prevIndex() + 1L);
        this.allSegments.subList(0, firstRemaining).clear();
        return notDisposed;
    }

    synchronized void visit(Visitor<SegmentFile, RuntimeException> visitor) {
        ListIterator<SegmentFile> itr = this.allSegments.listIterator();
        boolean terminate = false;
        while (itr.hasNext() && !terminate) {
            terminate = visitor.visit((Object)itr.next());
        }
    }

    synchronized void visitBackwards(Visitor<SegmentFile, RuntimeException> visitor) {
        ListIterator<SegmentFile> itr = this.allSegments.listIterator(this.allSegments.size());
        boolean terminate = false;
        while (itr.hasPrevious() && !terminate) {
            terminate = visitor.visit((Object)itr.previous());
        }
    }

    @Override
    public synchronized void close() throws DisposedException {
        RuntimeException error = null;
        for (SegmentFile segment : this.allSegments) {
            try {
                segment.close();
            }
            catch (RuntimeException ex) {
                if (error == null) {
                    error = ex;
                    continue;
                }
                error.addSuppressed(ex);
            }
        }
        if (error != null) {
            throw error;
        }
    }
}

