/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import org.neo4j.causalclustering.core.consensus.log.EntryRecord;
import org.neo4j.causalclustering.core.consensus.log.segmented.DamagedLogStorageException;
import org.neo4j.causalclustering.core.consensus.log.segmented.DisposedException;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReaderPool;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentFile;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentHeader;
import org.neo4j.causalclustering.core.consensus.log.segmented.Segments;
import org.neo4j.causalclustering.core.consensus.log.segmented.State;
import org.neo4j.causalclustering.core.consensus.log.segmented.Terms;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.cursor.IOCursor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalFlushableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadChannel;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

class RecoveryProtocol {
    private static final SegmentHeader.Marshal headerMarshal = new SegmentHeader.Marshal();
    private final FileSystemAbstraction fileSystem;
    private final FileNames fileNames;
    private final ChannelMarshal<ReplicatedContent> contentMarshal;
    private final LogProvider logProvider;
    private final Log log;
    private ReaderPool readerPool;

    RecoveryProtocol(FileSystemAbstraction fileSystem, FileNames fileNames, ReaderPool readerPool, ChannelMarshal<ReplicatedContent> contentMarshal, LogProvider logProvider) {
        this.fileSystem = fileSystem;
        this.fileNames = fileNames;
        this.readerPool = readerPool;
        this.contentMarshal = contentMarshal;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
    }

    State run() throws IOException, DamagedLogStorageException, DisposedException {
        State state = new State();
        SortedMap<Long, File> files = this.fileNames.getAllFiles(this.fileSystem, this.log);
        if (files.entrySet().isEmpty()) {
            state.segments = new Segments(this.fileSystem, this.fileNames, this.readerPool, Collections.emptyList(), this.contentMarshal, this.logProvider, -1L);
            state.segments.rotate(-1L, -1L, -1L);
            state.terms = new Terms(-1L, -1L);
            return state;
        }
        ArrayList<SegmentFile> segmentFiles = new ArrayList<SegmentFile>();
        SegmentFile segment = null;
        long expectedVersion = files.firstKey();
        boolean mustRecoverLastHeader = false;
        boolean skip = true;
        for (Map.Entry<Long, File> entry : files.entrySet()) {
            SegmentHeader header;
            long fileNameVersion = entry.getKey();
            File file = entry.getValue();
            RecoveryProtocol.checkVersionSequence(fileNameVersion, expectedVersion);
            try {
                header = RecoveryProtocol.loadHeader(this.fileSystem, file);
                RecoveryProtocol.checkVersionMatches(header.version(), fileNameVersion);
            }
            catch (EndOfStreamException e) {
                if (files.lastKey() != fileNameVersion) {
                    throw new DamagedLogStorageException(e, "Intermediate file with incomplete or no header found: %s", file);
                }
                if (files.size() == 1) {
                    throw new DamagedLogStorageException(e, "Single file with incomplete or no header found: %s", file);
                }
                mustRecoverLastHeader = true;
                break;
            }
            segment = new SegmentFile(this.fileSystem, file, this.readerPool, fileNameVersion, this.contentMarshal, this.logProvider, header);
            segmentFiles.add(segment);
            if (segment.header().prevIndex() != segment.header().prevFileLastIndex()) {
                this.log.info(String.format("Skipping from index %d to %d.", segment.header().prevFileLastIndex(), segment.header().prevIndex() + 1L));
                skip = true;
            }
            if (skip) {
                state.prevIndex = segment.header().prevIndex();
                state.prevTerm = segment.header().prevTerm();
                skip = false;
            }
            ++expectedVersion;
        }
        assert (segment != null);
        state.appendIndex = segment.header().prevIndex();
        state.terms = new Terms(segment.header().prevIndex(), segment.header().prevTerm());
        Throwable throwable = null;
        try (IOCursor<EntryRecord> cursor = segment.getCursor(segment.header().prevIndex() + 1L);){
            while (cursor.next()) {
                EntryRecord entry3 = (EntryRecord)cursor.get();
                state.appendIndex = entry3.logIndex();
                state.terms.append(state.appendIndex, entry3.logEntry().term());
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (mustRecoverLastHeader) {
            SegmentHeader header = new SegmentHeader(state.appendIndex, expectedVersion, state.appendIndex, state.terms.latest());
            this.log.warn("Recovering last file based on next-to-last file. " + header);
            File file = this.fileNames.getForVersion(expectedVersion);
            RecoveryProtocol.writeHeader(this.fileSystem, file, header);
            segment = new SegmentFile(this.fileSystem, file, this.readerPool, expectedVersion, this.contentMarshal, this.logProvider, header);
            segmentFiles.add(segment);
        }
        state.segments = new Segments(this.fileSystem, this.fileNames, this.readerPool, segmentFiles, this.contentMarshal, this.logProvider, segment.header().version());
        return state;
    }

    private static SegmentHeader loadHeader(FileSystemAbstraction fileSystem, File file) throws IOException, EndOfStreamException {
        try (StoreChannel channel = fileSystem.open(file, "r");){
            SegmentHeader segmentHeader = (SegmentHeader)headerMarshal.unmarshal((ReadableChannel)new ReadAheadChannel(channel, 32));
            return segmentHeader;
        }
    }

    private static void writeHeader(FileSystemAbstraction fileSystem, File file, SegmentHeader header) throws IOException {
        try (StoreChannel channel = fileSystem.open(file, "rw");){
            channel.position(0L);
            PhysicalFlushableChannel writer = new PhysicalFlushableChannel(channel, 32);
            headerMarshal.marshal(header, (WritableChannel)writer);
            writer.prepareForFlush().flush();
        }
    }

    private static void checkVersionSequence(long fileNameVersion, long expectedVersion) throws DamagedLogStorageException {
        if (fileNameVersion != expectedVersion) {
            throw new DamagedLogStorageException("File versions not strictly monotonic. Expected: %d but found: %d", expectedVersion, fileNameVersion);
        }
    }

    private static void checkVersionMatches(long headerVersion, long fileNameVersion) throws DamagedLogStorageException {
        if (headerVersion != fileNameVersion) {
            throw new DamagedLogStorageException("File version does not match header version. Expected: %d but found: %d", headerVersion, fileNameVersion);
        }
    }
}

