/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.pruning;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.neo4j.causalclustering.core.consensus.log.pruning.LogPruner;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class PruningScheduler
extends LifecycleAdapter {
    private final LogPruner logPruner;
    private final JobScheduler scheduler;
    private final long recurringPeriodMillis;
    private final Runnable job = new Runnable(){

        @Override
        public void run() {
            try {
                PruningScheduler.this.checkPointing = true;
                if (PruningScheduler.this.stopped) {
                    return;
                }
                PruningScheduler.this.logPruner.prune();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException((Throwable)e);
            }
            finally {
                PruningScheduler.this.checkPointing = false;
            }
            if (!PruningScheduler.this.stopped) {
                PruningScheduler.this.handle = PruningScheduler.this.scheduler.schedule(JobScheduler.Groups.raftLogPruning, PruningScheduler.this.job, PruningScheduler.this.recurringPeriodMillis, TimeUnit.MILLISECONDS);
            }
        }
    };
    private final Log log;
    private volatile JobScheduler.JobHandle handle;
    private volatile boolean stopped;
    private volatile boolean checkPointing;
    private final BooleanSupplier checkPointingCondition = new BooleanSupplier(){

        @Override
        public boolean getAsBoolean() {
            return !PruningScheduler.this.checkPointing;
        }
    };

    public PruningScheduler(LogPruner logPruner, JobScheduler scheduler, long recurringPeriodMillis, LogProvider logProvider) {
        this.logPruner = logPruner;
        this.scheduler = scheduler;
        this.recurringPeriodMillis = recurringPeriodMillis;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void start() throws Throwable {
        this.handle = this.scheduler.schedule(JobScheduler.Groups.raftLogPruning, this.job, this.recurringPeriodMillis, TimeUnit.MILLISECONDS);
    }

    public void stop() throws Throwable {
        this.log.info("PruningScheduler stopping");
        this.stopped = true;
        if (this.handle != null) {
            this.handle.cancel(false);
        }
        Predicates.awaitForever((BooleanSupplier)this.checkPointingCondition, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }
}

