/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;

public class InMemoryRaftLog
implements RaftLog {
    private final Map<Long, RaftLogEntry> raftLog = new HashMap<Long, RaftLogEntry>();
    private long prevIndex = -1L;
    private long prevTerm = -1L;
    private long appendIndex = -1L;
    private long commitIndex = -1L;
    private long term = -1L;

    @Override
    public synchronized long append(RaftLogEntry ... entries) throws IOException {
        long newAppendIndex = this.appendIndex;
        for (RaftLogEntry entry : entries) {
            newAppendIndex = this.appendSingle(entry);
        }
        return newAppendIndex;
    }

    private synchronized long appendSingle(RaftLogEntry logEntry) throws IOException {
        Objects.requireNonNull(logEntry);
        if (logEntry.term() < this.term) {
            throw new IllegalStateException(String.format("Non-monotonic term %d for in entry %s in term %d", logEntry.term(), logEntry.toString(), this.term));
        }
        this.term = logEntry.term();
        ++this.appendIndex;
        this.raftLog.put(this.appendIndex, logEntry);
        return this.appendIndex;
    }

    @Override
    public synchronized long prune(long safeIndex) {
        if (safeIndex > this.prevIndex) {
            long removeIndex = this.prevIndex + 1L;
            this.prevTerm = this.readEntryTerm(safeIndex);
            this.prevIndex = safeIndex;
            do {
                this.raftLog.remove(removeIndex);
            } while (++removeIndex <= safeIndex);
        }
        return this.prevIndex;
    }

    @Override
    public synchronized long appendIndex() {
        return this.appendIndex;
    }

    @Override
    public synchronized long prevIndex() {
        return this.prevIndex;
    }

    @Override
    public synchronized long readEntryTerm(long logIndex) {
        if (logIndex == this.prevIndex) {
            return this.prevTerm;
        }
        if (logIndex < this.prevIndex || logIndex > this.appendIndex) {
            return -1L;
        }
        return this.raftLog.get(logIndex).term();
    }

    @Override
    public synchronized void truncate(long fromIndex) {
        if (fromIndex <= this.commitIndex) {
            throw new IllegalArgumentException("cannot truncate before the commit index");
        }
        if (fromIndex > this.appendIndex) {
            throw new IllegalArgumentException("Cannot truncate at index " + fromIndex + " when append index is " + this.appendIndex);
        }
        if (fromIndex <= this.prevIndex) {
            this.prevIndex = -1L;
            this.prevTerm = -1L;
        }
        for (long i = this.appendIndex; i >= fromIndex; --i) {
            this.raftLog.remove(i);
        }
        if (this.appendIndex >= fromIndex) {
            this.appendIndex = fromIndex - 1L;
        }
        this.term = this.readEntryTerm(this.appendIndex);
    }

    @Override
    public synchronized RaftLogCursor getEntryCursor(final long fromIndex) throws IOException {
        return new RaftLogCursor(){
            private long currentIndex;
            RaftLogEntry current;
            {
                this.currentIndex = fromIndex - 1L;
                this.current = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean next() throws IOException {
                boolean hasNext;
                ++this.currentIndex;
                InMemoryRaftLog inMemoryRaftLog = InMemoryRaftLog.this;
                synchronized (inMemoryRaftLog) {
                    boolean bl = hasNext = this.currentIndex <= InMemoryRaftLog.this.appendIndex;
                    if (hasNext) {
                        if (this.currentIndex <= InMemoryRaftLog.this.prevIndex || this.currentIndex > InMemoryRaftLog.this.appendIndex) {
                            return false;
                        }
                        this.current = (RaftLogEntry)InMemoryRaftLog.this.raftLog.get(this.currentIndex);
                    } else {
                        this.current = null;
                    }
                }
                return hasNext;
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public long index() {
                return this.currentIndex;
            }

            public RaftLogEntry get() {
                return this.current;
            }
        };
    }

    @Override
    public synchronized long skip(long index, long term) {
        if (index > this.appendIndex) {
            this.raftLog.clear();
            this.appendIndex = index;
            this.prevIndex = index;
            this.prevTerm = term;
        }
        return this.appendIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InMemoryRaftLog that = (InMemoryRaftLog)o;
        return Objects.equals(this.appendIndex, that.appendIndex) && Objects.equals(this.commitIndex, that.commitIndex) && Objects.equals(this.term, that.term) && Objects.equals(this.raftLog, that.raftLog);
    }

    public int hashCode() {
        return Objects.hash(this.raftLog, this.appendIndex, this.commitIndex, this.term);
    }
}

