/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class ContinuousJob
extends LifecycleAdapter {
    private final AbortableJob abortableJob = new AbortableJob();
    private final JobScheduler scheduler;
    private final JobScheduler.Group group;
    private final Runnable task;
    private final Log log;
    private JobScheduler.JobHandle jobHandle;

    public ContinuousJob(JobScheduler scheduler, JobScheduler.Group group, Runnable task, LogProvider logProvider) {
        this.scheduler = scheduler;
        this.group = group;
        this.task = task;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void start() throws Throwable {
        this.abortableJob.keepRunning = true;
        this.jobHandle = this.scheduler.schedule(this.group, (Runnable)this.abortableJob);
    }

    public void stop() throws Throwable {
        this.log.info("ContinuousJob " + this.group.name() + " stopping");
        this.abortableJob.keepRunning = false;
        this.jobHandle.waitTermination();
    }

    private class AbortableJob
    implements Runnable {
        private volatile boolean keepRunning;

        private AbortableJob() {
        }

        @Override
        public void run() {
            while (this.keepRunning) {
                ContinuousJob.this.task.run();
            }
        }
    }
}

