/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup;

import java.io.IOException;
import java.time.Clock;
import java.util.concurrent.CompletableFuture;
import org.neo4j.causalclustering.catchup.CatchUpResponseCallback;
import org.neo4j.causalclustering.catchup.CatchUpResponseHandler;
import org.neo4j.causalclustering.catchup.storecopy.FileChunk;
import org.neo4j.causalclustering.catchup.storecopy.FileHeader;
import org.neo4j.causalclustering.catchup.storecopy.GetStoreIdResponse;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFinishedResponse;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponse;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;

class TrackingResponseHandler
implements CatchUpResponseHandler {
    private CatchUpResponseCallback delegate;
    private CompletableFuture<?> requestOutcomeSignal = new CompletableFuture();
    private final Clock clock;
    private long lastResponseTime;

    TrackingResponseHandler(CatchUpResponseCallback delegate, Clock clock) {
        this.delegate = delegate;
        this.clock = clock;
        this.lastResponseTime = clock.millis();
    }

    void setResponseHandler(CatchUpResponseCallback responseHandler, CompletableFuture<?> requestOutcomeSignal) {
        this.delegate = responseHandler;
        this.requestOutcomeSignal = requestOutcomeSignal;
    }

    @Override
    public void onFileHeader(FileHeader fileHeader) {
        if (!this.requestOutcomeSignal.isCancelled()) {
            this.recordLastResponse();
            this.delegate.onFileHeader(this.requestOutcomeSignal, fileHeader);
        }
    }

    @Override
    public boolean onFileContent(FileChunk fileChunk) throws IOException {
        if (!this.requestOutcomeSignal.isCancelled()) {
            this.recordLastResponse();
            return this.delegate.onFileContent(this.requestOutcomeSignal, fileChunk);
        }
        return true;
    }

    @Override
    public void onFileStreamingComplete(StoreCopyFinishedResponse response) {
        if (!this.requestOutcomeSignal.isCancelled()) {
            this.recordLastResponse();
            this.delegate.onFileStreamingComplete(this.requestOutcomeSignal, response);
        }
    }

    @Override
    public void onTxPullResponse(TxPullResponse tx) {
        if (!this.requestOutcomeSignal.isCancelled()) {
            this.recordLastResponse();
            this.delegate.onTxPullResponse(this.requestOutcomeSignal, tx);
        }
    }

    @Override
    public void onTxStreamFinishedResponse(TxStreamFinishedResponse response) {
        if (!this.requestOutcomeSignal.isCancelled()) {
            this.recordLastResponse();
            this.delegate.onTxStreamFinishedResponse(this.requestOutcomeSignal, response);
        }
    }

    @Override
    public void onGetStoreIdResponse(GetStoreIdResponse response) {
        if (!this.requestOutcomeSignal.isCancelled()) {
            this.recordLastResponse();
            this.delegate.onGetStoreIdResponse(this.requestOutcomeSignal, response);
        }
    }

    @Override
    public void onCoreSnapshot(CoreSnapshot coreSnapshot) {
        if (!this.requestOutcomeSignal.isCancelled()) {
            this.recordLastResponse();
            this.delegate.onCoreSnapshot(this.requestOutcomeSignal, coreSnapshot);
        }
    }

    long lastResponseTime() {
        return this.lastResponseTime;
    }

    private void recordLastResponse() {
        this.lastResponseTime = this.clock.millis();
    }
}

