/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class VersionDecoder
extends ByteToMessageDecoder {
    private final Log log;
    private final byte currentVersion;

    protected VersionDecoder(LogProvider logProvider, byte currentVersion) {
        this.currentVersion = currentVersion;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public VersionDecoder(LogProvider logProvider) {
        this(logProvider, 0);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        byte version = in.readByte();
        if (version != this.currentVersion) {
            this.log.error("Unsupported version %d, current version is %d", new Object[]{version, this.currentVersion});
        } else {
            ByteBuf retained = in.slice(in.readerIndex(), in.readableBytes()).retain();
            in.readerIndex(in.writerIndex());
            out.add(retained);
        }
    }
}

