/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.capabilities;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.neo4j.capabilities.Name;
import org.neo4j.capabilities.Type;

public final class Capability<T> {
    private final Name name;
    private final Type<T> type;
    private boolean internal;
    private String description;

    public Capability(@Nonnull Name name, @Nonnull Type<T> type) {
        this(name, type, "", true);
    }

    private Capability(@Nonnull Name name, @Nonnull Type<T> type, @Nonnull String description, boolean internal) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.description = Objects.requireNonNull(description);
        this.internal = internal;
    }

    @Nonnull
    public Name name() {
        return this.name;
    }

    @Nonnull
    public String description() {
        return this.description;
    }

    public boolean internal() {
        return this.internal;
    }

    @Nonnull
    public Type<T> type() {
        return this.type;
    }

    void setDescription(@Nonnull String description) {
        this.description = Objects.requireNonNull(description);
    }

    void setPublic() {
        this.internal = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Capability that = (Capability)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "Capability{name=" + this.name + ", type=" + this.type + "}";
    }
}

