/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v43.fsm.state;

import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.connection.RouteMessage;
import org.neo4j.dbms.routing.RoutingException;
import org.neo4j.dbms.routing.RoutingResult;
import org.neo4j.dbms.routing.result.RoutingResultFormat;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class ReadyState
extends org.neo4j.bolt.protocol.v40.fsm.state.ReadyState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ReadyState.class);
    private static final String ROUTING_TABLE_KEY = "rt";

    @Override
    public State processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        if (message instanceof RouteMessage) {
            RouteMessage routeMessage = (RouteMessage)message;
            return this.processRouteMessage(routeMessage, context);
        }
        return super.processUnsafe(message, context);
    }

    protected State processRouteMessage(RouteMessage message, StateMachineContext context) throws Exception {
        try {
            String user = context.connection().username();
            RoutingResult result = context.connection().connector().routingService().route(message.getDatabaseName(), user, message.getRequestContext());
            this.onRoutingTableReceived(context, message, RoutingResultFormat.buildMap((RoutingResult)result));
        }
        catch (RoutingException ex) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                context.handleFailure(cause, false);
                return this.failedState;
            }
            throw ex;
        }
        return this;
    }

    protected void onRoutingTableReceived(StateMachineContext context, RouteMessage message, MapValue routingTable) {
        context.connectionState().onMetadata(ROUTING_TABLE_KEY, (AnyValue)routingTable);
    }
}

