/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.packstream.error.reader.PackstreamReaderException;

public class RequestHandler
extends SimpleChannelInboundHandler<RequestMessage> {
    private final InternalLog log;
    private Connection connection;

    public RequestHandler(InternalLogProvider logging) {
        this.log = logging.getLog(RequestHandler.class);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.connection = Connection.getConnection(ctx.channel());
    }

    protected void channelRead0(ChannelHandlerContext ctx, RequestMessage msg) throws Exception {
        this.log.debug("Submitting job for message %s", new Object[]{msg});
        this.connection.submit(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Throwable inner;
        Throwable ex = cause;
        if (cause instanceof DecoderException && (inner = cause.getCause()) != null) {
            ex = inner;
        }
        if (!(ex instanceof PackstreamReaderException) && !(ex instanceof Status.HasStatus)) {
            super.exceptionCaught(ctx, cause);
            return;
        }
        Error error = Error.from(cause);
        this.connection.submit((fsm, responseHandler) -> fsm.handleExternalFailure(error, responseHandler));
    }
}

