/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.connection.listener;

import io.netty.channel.ChannelHandler;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.listener.ConnectionListener;
import org.neo4j.bolt.protocol.common.handler.KeepAliveHandler;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;

public class KeepAliveConnectionListener
implements ConnectionListener {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(KeepAliveConnectionListener.class);
    private final Connection connection;
    private final boolean legacyMode;
    private final long writerIdleTimeSeconds;
    private final InternalLogProvider logging;
    private final InternalLog log;

    public KeepAliveConnectionListener(Connection connection, boolean legacyMode, long writeIdleTime, InternalLogProvider logging) {
        this.connection = connection;
        this.legacyMode = legacyMode;
        this.writerIdleTimeSeconds = writeIdleTime;
        this.logging = logging;
        this.log = logging.getLog(KeepAliveConnectionListener.class);
    }

    @Override
    public void onListenerRemoved() {
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    @Override
    public void onProtocolSelected(BoltProtocol protocol) {
        this.log.debug("[%s] Installing keep alive handler", new Object[]{this.connection.id()});
        this.connection.memoryTracker().allocateHeap(KeepAliveHandler.SHALLOW_SIZE);
        this.connection.channel().pipeline().addLast(new ChannelHandler[]{new KeepAliveHandler(this.legacyMode, this.writerIdleTimeSeconds, this.logging)});
        this.connection.removeListener(this);
    }
}

