/*
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Neo4j is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.neo4j.bolt.dbapi;

import java.util.Optional;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.Status;

/**
 * A transaction representation as seen and used by Bolt.
 */
public interface BoltTransaction extends BoltQueryExecutor, AutoCloseable {
    void commit() throws TransactionFailureException;

    void rollback() throws TransactionFailureException;

    @Override
    void close() throws TransactionFailureException;

    /**
     * Terminates the transaction. The main difference between this operation and {@link #rollback()} is
     * that a transaction must be rolled back from a thread bound to the transaction, but it can be terminated from any thread.
     */
    void markForTermination(Status reason);

    /**
     * Terminates the transaction. The main difference between this operation and {@link #rollback()} is
     * that a transaction must be rolled back from a thread bound to the transaction, but it can be terminated from any thread.
     */
    void markForTermination();

    Optional<Status> getReasonIfTerminated();

    BookmarkMetadata getBookmarkMetadata();
}
