/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v51.message.decoder;

import java.util.Map;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.message.decoder.ReadMetadataUtils;
import org.neo4j.bolt.protocol.v51.message.request.LogonMessage;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;

public class LogonMessageDecoder
implements StructReader<Connection, LogonMessage> {
    private static final LogonMessageDecoder INSTANCE = new LogonMessageDecoder();

    public static LogonMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 106;
    }

    @Override
    public LogonMessage read(Connection connection, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 1L) {
            throw new IllegalStructSizeException(1L, header.length());
        }
        PackstreamValueReader<Connection> valueReader = connection.valueReader(buffer);
        Map<String, Object> authToken = this.readMetadataMap(valueReader, buffer.getTarget().readableBytes());
        return new LogonMessage(authToken);
    }

    protected Map<String, Object> readMetadataMap(PackstreamValueReader<Connection> reader, int limit) throws PackstreamReaderException {
        return ReadMetadataUtils.readMetadataMap(reader, limit);
    }
}

