/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v51.fsm;

import java.util.List;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.common.connector.connection.MutableConnectionState;
import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPI;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.v41.message.request.RoutingContext;
import org.neo4j.bolt.protocol.v51.message.request.HelloMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValueBuilder;

public class NegotiationState
implements State {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(NegotiationState.class);
    private static final String CONNECTION_ID_KEY = "connection_id";
    protected State authenticationState;

    @Override
    public String name() {
        return "NEGOTIATION";
    }

    @Override
    public State process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        Preconditions.checkState((this.authenticationState != null ? 1 : 0) != 0, (String)"Authentication state not set");
        if (message instanceof HelloMessage) {
            HelloMessage helloMessage = (HelloMessage)message;
            RoutingContext routingContext = this.extractRoutingContext(helloMessage);
            List<Feature> enabledFeatures = context.connection().negotiate(helloMessage.features(), helloMessage.userAgent(), routingContext);
            MutableConnectionState connectionState = context.connectionState();
            StateMachineSPI boltSpi = context.boltSpi();
            connectionState.onMetadata(CONNECTION_ID_KEY, (AnyValue)Values.utf8Value((String)context.connectionId()));
            connectionState.onMetadata("server", (AnyValue)Values.utf8Value((String)boltSpi.version()));
            MapValueBuilder connectionHints = new MapValueBuilder();
            context.connection().connector().connectionHintProvider().append(connectionHints);
            connectionState.onMetadata("hints", (AnyValue)connectionHints.build());
            if (!enabledFeatures.isEmpty()) {
                ListValueBuilder builder = ListValueBuilder.newListBuilder((int)enabledFeatures.size());
                enabledFeatures.forEach(feature -> builder.add((AnyValue)Values.stringValue((String)feature.getId())));
                context.connectionState().onMetadata("patch_bolt", (AnyValue)builder.build());
            }
            return this.authenticationState;
        }
        return null;
    }

    protected RoutingContext extractRoutingContext(HelloMessage message) {
        return message.routingContext();
    }

    public void setAuthenticationState(State authenticationState) {
        this.authenticationState = authenticationState;
    }
}

