/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v51.fsm;

import java.util.Map;
import org.neo4j.bolt.protocol.common.connector.connection.authentication.AuthenticationFlag;
import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.v40.fsm.FailSafeState;
import org.neo4j.bolt.protocol.v51.message.request.LogonMessage;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;

public class AuthenticationState
extends FailSafeState {
    public static long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(AuthenticationState.class);
    private State readyState;

    @Override
    public String name() {
        return "AUTHENTICATION";
    }

    @Override
    public State processUnsafe(RequestMessage message, StateMachineContext context) throws AuthenticationException {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
        if (message instanceof LogonMessage) {
            LogonMessage logonMessage = (LogonMessage)message;
            this.processLogonMessage(context, logonMessage);
            return this.readyState;
        }
        return null;
    }

    protected void processLogonMessage(StateMachineContext context, LogonMessage message) throws AuthenticationException {
        Map<String, Object> authToken = message.authToken();
        AuthenticationFlag flags = context.connection().logon(authToken);
        if (flags != null) {
            context.connectionState().onMetadata(flags.name().toLowerCase(), (AnyValue)Values.TRUE);
        }
    }

    public void setReadyState(State readyState) {
        this.readyState = readyState;
    }
}

