/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v44.fsm;

import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.routing.RoutingTableGetter;
import org.neo4j.bolt.protocol.v40.messaging.request.RunMessage;
import org.neo4j.bolt.protocol.v43.message.request.RouteMessage;
import org.neo4j.bolt.protocol.v44.message.request.BeginMessage;
import org.neo4j.bolt.security.error.AuthenticationException;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public class ReadyState
extends org.neo4j.bolt.protocol.v43.fsm.ReadyState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(org.neo4j.bolt.protocol.v43.fsm.ReadyState.class);

    public ReadyState(RoutingTableGetter routingTableGetter) {
        super(routingTableGetter);
    }

    @Override
    public State processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        if (message instanceof org.neo4j.bolt.protocol.v44.message.request.RouteMessage || message instanceof org.neo4j.bolt.protocol.v44.message.request.RunMessage || message instanceof BeginMessage) {
            return super.processUnsafe(message, context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected State processRouteMessage(RouteMessage message, StateMachineContext context) throws Exception {
        org.neo4j.bolt.protocol.v44.message.request.RouteMessage routeMessage = (org.neo4j.bolt.protocol.v44.message.request.RouteMessage)message;
        context.connection().impersonate(routeMessage.impersonatedUser());
        try {
            State state = super.processRouteMessage(message, context);
            return state;
        }
        finally {
            context.connection().impersonate(null);
        }
    }

    @Override
    protected void onRoutingTableReceived(StateMachineContext context, RouteMessage message, MapValue routingTable) {
        String databaseName = message.getDatabaseName();
        if (databaseName == null || "".equals(message.getDatabaseName())) {
            context.connection().resolveDefaultDatabase();
            databaseName = context.connection().selectedDefaultDatabase();
        }
        super.onRoutingTableReceived(context, message, routingTable.updatedWith("db", (AnyValue)Values.stringValue((String)databaseName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected State processRunMessage(RunMessage message, StateMachineContext context) throws Exception {
        org.neo4j.bolt.protocol.v44.message.request.RunMessage runMessage = (org.neo4j.bolt.protocol.v44.message.request.RunMessage)message;
        this.authenticateImpersonation(context, runMessage.impersonatedUser());
        try {
            State state = super.processRunMessage(message, context);
            return state;
        }
        finally {
            context.connection().impersonate(null);
        }
    }

    @Override
    protected State processBeginMessage(org.neo4j.bolt.protocol.v40.messaging.request.BeginMessage message, StateMachineContext context) throws Exception {
        BeginMessage beginMessage = (BeginMessage)message;
        this.authenticateImpersonation(context, beginMessage.impersonatedUser());
        return super.processBeginMessage(message, context);
    }

    private void authenticateImpersonation(StateMachineContext context, String username) throws AuthenticationException {
        context.connection().impersonate(username);
    }
}

