/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.messaging.request;

import java.util.Objects;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.values.virtual.MapValue;

public abstract class AbstractStreamingMessage
implements RequestMessage {
    private final MapValue meta;
    private final long n;
    private final long statementId;

    public AbstractStreamingMessage(MapValue meta, long n, long statementId) {
        this.meta = Objects.requireNonNull(meta);
        this.n = n;
        this.statementId = statementId;
    }

    public long n() {
        return this.n;
    }

    public long statementId() {
        return this.statementId;
    }

    public MapValue meta() {
        return this.meta;
    }

    @Override
    public boolean safeToProcessInAnyState() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractStreamingMessage that = (AbstractStreamingMessage)o;
        return Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(this.meta);
    }

    public String toString() {
        return String.format("%s %s", this.name(), this.meta());
    }

    abstract String name();
}

