/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.messaging.decoder;

import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.v40.messaging.request.PullMessage;
import org.neo4j.bolt.protocol.v40.messaging.util.MessageMetadataParserV40;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.virtual.MapValue;

public final class PullMessageDecoder
implements StructReader<Connection, PullMessage> {
    private static final PullMessageDecoder INSTANCE = new PullMessageDecoder();

    private PullMessageDecoder() {
    }

    public static PullMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 63;
    }

    @Override
    public PullMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        MapValue meta;
        if (header.length() != 1L) {
            throw new IllegalStructSizeException(1L, header.length());
        }
        PackstreamValueReader<Connection> valueReader = ctx.valueReader(buffer);
        try {
            meta = valueReader.readMap();
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("meta", ex);
        }
        try {
            long n = MessageMetadataParserV40.parseStreamLimit(meta);
            long statementId = MessageMetadataParserV40.parseStatementId(meta);
            return new PullMessage(meta, n, statementId);
        }
        catch (PackstreamReaderException ex) {
            throw new IllegalStructArgumentException("meta", ex);
        }
    }
}

