/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm;

import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.signal.StateSignal;
import org.neo4j.bolt.protocol.v40.fsm.FailSafeState;
import org.neo4j.bolt.protocol.v40.messaging.request.BeginMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.RunMessage;
import org.neo4j.bolt.tx.Transaction;
import org.neo4j.bolt.tx.TransactionType;
import org.neo4j.bolt.tx.statement.Statement;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;

public class ReadyState
extends FailSafeState {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ReadyState.class);
    protected State streamingState;
    protected State txReadyState;

    public void setStreamingState(State streamingState) {
        this.streamingState = streamingState;
    }

    public void setTransactionReadyState(State txReadyState) {
        this.txReadyState = txReadyState;
    }

    @Override
    public String name() {
        return "READY";
    }

    @Override
    protected void assertInitialized() {
        Preconditions.checkState((this.streamingState != null ? 1 : 0) != 0, (String)"Streaming state not set");
        Preconditions.checkState((this.txReadyState != null ? 1 : 0) != 0, (String)"TransactionReady state not set");
        super.assertInitialized();
    }

    @Override
    public State processUnsafe(RequestMessage message, StateMachineContext context) throws Exception {
        this.assertInitialized();
        if (message instanceof RunMessage) {
            RunMessage runMessage = (RunMessage)message;
            return this.processRunMessage(runMessage, context);
        }
        if (message instanceof BeginMessage) {
            BeginMessage beginMessage = (BeginMessage)message;
            return this.processBeginMessage(beginMessage, context);
        }
        return null;
    }

    protected State processRunMessage(RunMessage message, StateMachineContext context) throws Exception {
        long start = context.clock().millis();
        Transaction tx = context.connection().beginTransaction(TransactionType.IMPLICIT, message.databaseName(), message.getAccessMode(), message.bookmarks(), message.transactionTimeout(), message.transactionMetadata());
        Statement statement = tx.run(message.statement(), message.params());
        long end = context.clock().millis();
        context.connectionState().getResponseHandler().onStatementPrepared(TransactionType.IMPLICIT, statement.id(), end - start, statement.fieldNames());
        context.connection().write((Object)StateSignal.ENTER_STREAMING);
        return this.streamingState;
    }

    protected State processBeginMessage(BeginMessage message, StateMachineContext context) throws Exception {
        TransactionType type = message.type();
        if (type == null) {
            type = TransactionType.EXPLICIT;
        }
        context.connection().beginTransaction(type, message.databaseName(), message.getAccessMode(), message.bookmarks(), message.transactionTimeout(), message.transactionMetadata());
        context.connection().write((Object)StateSignal.ENTER_STREAMING);
        return this.txReadyState;
    }

    protected State processLogoffMessage(StateMachineContext context) {
        return null;
    }
}

