/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.fsm;

import org.neo4j.bolt.protocol.common.fsm.State;
import org.neo4j.bolt.protocol.common.fsm.StateMachineContext;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.ResetMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.Preconditions;

public class InterruptedState
implements State {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(InterruptedState.class);
    private State readyState;

    @Override
    public State process(RequestMessage message, StateMachineContext context) throws BoltConnectionFatality {
        this.assertInitialized();
        if (message instanceof ResetMessage) {
            if (!context.connection().reset()) {
                context.connectionState().markIgnored();
                return this;
            }
            context.connectionState().resetPendingFailedAndIgnored();
            return this.readyState;
        }
        context.connectionState().markIgnored();
        return this;
    }

    @Override
    public String name() {
        return "INTERRUPTED";
    }

    public void setReadyState(State readyState) {
        this.readyState = readyState;
    }

    private void assertInitialized() {
        Preconditions.checkState((this.readyState != null ? 1 : 0) != 0, (String)"Ready state not set");
    }
}

