/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.bookmark;

import java.util.Objects;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.kernel.database.NamedDatabaseId;

public record BookmarkWithDatabaseId(long txId, NamedDatabaseId namedDatabaseId) implements Bookmark
{
    @Override
    public NamedDatabaseId databaseId() {
        return this.namedDatabaseId;
    }

    @Override
    public void attachTo(ResponseHandler state) {
        state.onBookmark(this.toString());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookmarkWithDatabaseId that = (BookmarkWithDatabaseId)o;
        return this.txId == that.txId && Objects.equals(this.namedDatabaseId, that.namedDatabaseId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.txId, this.namedDatabaseId);
    }

    @Override
    public String toString() {
        return String.format("%s:%d", this.namedDatabaseId.databaseId().uuid(), this.txId);
    }
}

