/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.connection;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAccumulator;
import org.neo4j.memory.MemoryPool;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.memory.ScopedMemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class ConnectionMemoryTracker
implements MemoryTracker {
    @VisibleForTesting
    static final long CHUNK_SIZE = 64L;
    private final MemoryPool parent;
    private final AtomicLong pooled = new AtomicLong(64L);
    private final AtomicLong allocated = new AtomicLong();
    private final LongAccumulator watermark = new LongAccumulator(Long::max, 0L);

    private ConnectionMemoryTracker(MemoryPool parent) {
        this.parent = parent;
    }

    public static ConnectionMemoryTracker createForPool(MemoryPool parent) {
        parent.reserveHeap(64L);
        return new ConnectionMemoryTracker(parent);
    }

    public long usedNativeMemory() {
        return 0L;
    }

    public long estimatedHeapMemory() {
        return this.allocated.get();
    }

    public void allocateNative(long bytes) {
        throw new UnsupportedOperationException("Reporting per-connection native allocation is not supported");
    }

    public void releaseNative(long bytes) {
    }

    private long requestFromLocalPool(long expected, long request) {
        if (this.pooled.compareAndSet(expected, expected - request)) {
            return request;
        }
        return 0L;
    }

    private void request(long requested) {
        long allocation;
        long previousAvailable;
        long remaining = requested;
        do {
            if ((previousAvailable = this.pooled.get()) > remaining) {
                allocation = remaining;
                continue;
            }
            if (previousAvailable != 0L) {
                allocation = previousAvailable;
                continue;
            }
            long requiredChunks = remaining / 64L + 1L;
            long request = requiredChunks * 64L;
            this.parent.reserveHeap(request);
            this.pooled.addAndGet(request - remaining);
            return;
        } while ((remaining -= this.requestFromLocalPool(previousAvailable, allocation)) != 0L);
    }

    public void allocateHeap(long bytes) {
        this.request(bytes);
        long allocated = this.allocated.addAndGet(bytes);
        this.watermark.accumulate(allocated);
    }

    public void releaseHeap(long bytes) {
        long previousPool;
        long newPool;
        long newAllocation;
        long previousAllocation;
        do {
            previousAllocation = this.allocated.get();
            assert (previousAllocation >= bytes) : "Can't release more than it was allocated. Allocated heap: " + previousAllocation + ", release request: " + bytes;
        } while (!this.allocated.compareAndSet(previousAllocation, newAllocation = previousAllocation - bytes));
        long release = 0L;
        while ((newPool = (previousPool = this.pooled.get()) + bytes) >= 64L && newPool / 2L >= newAllocation && !this.pooled.compareAndSet(previousPool, newPool -= (release = newPool / 4L))) {
        }
        if (release != 0L) {
            this.parent.releaseHeap(release);
        }
    }

    public long heapHighWaterMark() {
        return this.watermark.get();
    }

    public MemoryTracker getScopedMemoryTracker() {
        return new ScopedMemoryTracker((MemoryTracker)this);
    }

    public void reset() {
        long returnedToLocal;
        long newPooledMemory;
        long previousPooledMemory;
        long reclaimedMemory = this.allocated.getAndSet(0L);
        long returnedToParent = 0L;
        do {
            if ((previousPooledMemory = this.pooled.get()) >= 64L) {
                returnedToLocal = 0L;
                returnedToParent = previousPooledMemory - 64L;
                newPooledMemory = 64L;
                continue;
            }
            returnedToLocal = 64L - previousPooledMemory;
            newPooledMemory = previousPooledMemory + returnedToLocal;
        } while (!this.pooled.compareAndSet(previousPooledMemory, newPooledMemory));
        reclaimedMemory -= returnedToLocal;
        if ((reclaimedMemory += returnedToParent) != 0L) {
            this.parent.releaseHeap(reclaimedMemory);
        }
        this.watermark.reset();
    }

    public void close() {
        long previouslyPooled = this.pooled.getAndSet(0L);
        long previouslyAllocated = this.allocated.getAndSet(0L);
        this.parent.releaseHeap(previouslyPooled + previouslyAllocated);
    }
}

