/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v44.message.decoder;

import java.util.List;
import java.util.Optional;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.v44.message.request.RouteMessage;
import org.neo4j.bolt.protocol.v44.message.util.MessageMetadataParserV44;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.io.Type;
import org.neo4j.packstream.io.value.PackstreamValueReader;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public final class RouteMessageDecoder
implements StructReader<Connection, RouteMessage> {
    private static final RouteMessageDecoder INSTANCE = new RouteMessageDecoder();
    public static final String DB_KEY = "db";

    private RouteMessageDecoder() {
    }

    public static RouteMessageDecoder getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return 102;
    }

    @Override
    public RouteMessage read(Connection ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        if (header.length() != 3L) {
            throw new IllegalStructSizeException(3L, header.length());
        }
        PackstreamValueReader<Connection> valueReader = ctx.valueReader(buffer);
        MapValue routingContext = valueReader.readMap();
        List<Bookmark> bookmarkList = List.of();
        if (buffer.peekType() != Type.NONE) {
            bookmarkList = ctx.connector().bookmarkParser().parseBookmarks(valueReader.readList());
        }
        MapValue meta = valueReader.readMap();
        String databaseName = Optional.of(meta.get(DB_KEY)).filter(any -> any != Values.NO_VALUE && any instanceof TextValue).map(any -> ((TextValue)any).stringValue()).orElse(null);
        String impersonatedUser = MessageMetadataParserV44.parseImpersonatedUser(meta);
        return this.newRouteMessage(routingContext, bookmarkList, meta, databaseName, impersonatedUser);
    }

    protected RouteMessage newRouteMessage(MapValue routingContext, List<Bookmark> bookmarkList, MapValue meta, String databaseName, String impersonatedUser) {
        return new RouteMessage(routingContext, bookmarkList, databaseName, impersonatedUser);
    }
}

