/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.transaction.statement;

import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseServiceSPI;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.protocol.common.connector.tx.TransactionOwner;
import org.neo4j.bolt.protocol.common.transaction.TransactionStateMachineSPI;
import org.neo4j.bolt.protocol.common.transaction.TransactionStateMachineSPIProvider;
import org.neo4j.bolt.protocol.common.transaction.statement.StatementProcessorReleaseManager;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.time.SystemNanoClock;

public abstract class AbstractTransactionStatementSPIProvider
implements TransactionStateMachineSPIProvider {
    protected final SystemNanoClock clock;
    protected final TransactionOwner owner;
    protected final BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI;
    protected final MemoryTracker memoryTracker;

    public AbstractTransactionStatementSPIProvider(BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, TransactionOwner owner, SystemNanoClock clock) {
        this.boltGraphDatabaseManagementServiceSPI = boltGraphDatabaseManagementServiceSPI;
        this.clock = clock;
        this.owner = owner;
        this.memoryTracker = owner.memoryTracker().getScopedMemoryTracker();
    }

    protected abstract TransactionStateMachineSPI newTransactionStateMachineSPI(BoltGraphDatabaseServiceSPI var1, StatementProcessorReleaseManager var2, String var3) throws BoltIOException;

    @Override
    public TransactionStateMachineSPI getTransactionStateMachineSPI(String databaseName, StatementProcessorReleaseManager resourceReleaseManager, String transactionId) throws BoltIOException {
        String selectedDatabaseName = this.selectDatabaseName(databaseName);
        try {
            BoltGraphDatabaseServiceSPI boltGraphDatabaseServiceSPI = this.boltGraphDatabaseManagementServiceSPI.database(selectedDatabaseName, this.memoryTracker);
            return this.newTransactionStateMachineSPI(boltGraphDatabaseServiceSPI, resourceReleaseManager, transactionId);
        }
        catch (DatabaseNotFoundException e) {
            throw new BoltIOException((Status)Status.Database.DatabaseNotFound, String.format("Database does not exist. Database name: '%s'.", selectedDatabaseName));
        }
        catch (UnavailableException e) {
            throw new BoltIOException((Status)Status.General.DatabaseUnavailable, String.format("Database '%s' is unavailable.", selectedDatabaseName));
        }
    }

    protected String selectDatabaseName(String databaseName) {
        if ("".equals(databaseName)) {
            return this.owner.selectedDefaultDatabase();
        }
        return databaseName;
    }

    @Override
    public void releaseTransactionStateMachineSPI() {
        this.memoryTracker.reset();
    }
}

