/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.transaction.result;

import java.io.IOException;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.exceptions.CypherExecutionException;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.values.AnyValue;

public class AdaptingBoltQuerySubscriber
implements QuerySubscriber {
    private BoltResult.RecordConsumer recordConsumer;
    private Throwable error;
    private QueryStatistics statistics;
    private int numberOfFields;

    public void onResult(int numberOfFields) {
        this.numberOfFields = numberOfFields;
    }

    public void onRecord() throws IOException {
        this.recordConsumer.beginRecord(this.numberOfFields);
    }

    public void onField(int offset, AnyValue value) throws IOException {
        this.recordConsumer.consumeField(value);
    }

    public void onRecordCompleted() throws Exception {
        this.recordConsumer.endRecord();
    }

    public void onError(Throwable throwable) throws IOException {
        if (this.error == null) {
            this.error = throwable;
        }
        if (this.recordConsumer != null) {
            this.recordConsumer.onError();
        }
    }

    public void onResultCompleted(QueryStatistics statistics) {
        this.statistics = statistics;
    }

    public QueryStatistics queryStatistics() {
        return this.statistics;
    }

    public void setRecordConsumer(BoltResult.RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void assertSucceeded() throws KernelException {
        if (this.error != null) {
            if (this.error instanceof KernelException) {
                throw (KernelException)this.error;
            }
            if (this.error instanceof Status.HasStatus) {
                throw new QueryExecutionKernelException((Throwable)((Status.HasStatus)this.error));
            }
            throw new QueryExecutionKernelException((Throwable)new CypherExecutionException(this.error.getMessage(), this.error));
        }
    }
}

