/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Date;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.server.config.AuthConfigProvider;

public class DiscoveryResponseHandler
extends ChannelInboundHandlerAdapter {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(DiscoveryResponseHandler.class);
    private final AuthConfigProvider authConfigProvider;

    public DiscoveryResponseHandler(AuthConfigProvider authConfigProvider) {
        this.authConfigProvider = authConfigProvider;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        FullHttpMessage httpMessage = (FullHttpMessage)msg;
        if (!DiscoveryResponseHandler.isWebsocketUpgrade(httpMessage.headers())) {
            DefaultFullHttpResponse discoveryResponse = new DefaultFullHttpResponse(httpMessage.protocolVersion(), HttpResponseStatus.OK, Unpooled.copiedBuffer((byte[])this.authConfigProvider.getRepresentationAsBytes()));
            this.addHeaders((FullHttpMessage)discoveryResponse);
            ctx.writeAndFlush((Object)discoveryResponse).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.pipeline().remove((ChannelHandler)this);
            ctx.fireChannelRead(msg);
        }
    }

    private void addHeaders(FullHttpMessage discoveryResponse) {
        discoveryResponse.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        discoveryResponse.headers().add((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)AsciiString.cached((String)"*"));
        discoveryResponse.headers().add((CharSequence)HttpHeaderNames.VARY, (Object)AsciiString.cached((String)"Accept"));
        discoveryResponse.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)discoveryResponse.content().readableBytes());
        discoveryResponse.headers().add((CharSequence)HttpHeaderNames.DATE, (Object)new Date());
        HttpUtil.setContentLength((HttpMessage)discoveryResponse, (long)discoveryResponse.content().readableBytes());
    }

    private static boolean isWebsocketUpgrade(HttpHeaders headers) {
        return headers.contains((CharSequence)HttpHeaderNames.UPGRADE) && headers.containsValue((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.UPGRADE, true) && headers.contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true);
    }
}

