/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v43;

import java.time.Clock;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.StateMachineSPIImpl;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.v40.transaction.TransactionStateMachineSPIProviderV4;
import org.neo4j.bolt.protocol.v42.BoltProtocolV42;
import org.neo4j.bolt.protocol.v43.fsm.StateMachineV43;
import org.neo4j.bolt.protocol.v43.message.decoder.RouteMessageDecoder;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.logging.internal.LogService;
import org.neo4j.packstream.struct.StructRegistry;
import org.neo4j.time.SystemNanoClock;

public class BoltProtocolV43
extends BoltProtocolV42 {
    public static final ProtocolVersion VERSION = new ProtocolVersion(4, 3);

    public BoltProtocolV43(LogService logging, BoltGraphDatabaseManagementServiceSPI boltGraphDatabaseManagementServiceSPI, DefaultDatabaseResolver defaultDatabaseResolver, TransactionManager transactionManager, SystemNanoClock clock) {
        super(logging, boltGraphDatabaseManagementServiceSPI, defaultDatabaseResolver, transactionManager, clock);
    }

    @Override
    public ProtocolVersion version() {
        return VERSION;
    }

    @Override
    protected StructRegistry<Connection, RequestMessage> createRequestMessageRegistry() {
        return super.createRequestMessageRegistry().builderOf().register(RouteMessageDecoder.getInstance()).build();
    }

    @Override
    public StateMachine createStateMachine(Connection connection) {
        connection.memoryTracker().allocateHeap(TransactionStateMachineSPIProviderV4.SHALLOW_SIZE + StateMachineSPIImpl.SHALLOW_SIZE + StateMachineV43.SHALLOW_SIZE);
        TransactionStateMachineSPIProviderV4 transactionSpiProvider = new TransactionStateMachineSPIProviderV4(this.boltGraphDatabaseManagementServiceSPI, connection, this.clock);
        StateMachineSPIImpl boltSPI = new StateMachineSPIImpl(this.logging, transactionSpiProvider);
        return new StateMachineV43(boltSPI, connection, (Clock)this.clock, this.defaultDatabaseResolver, this.transactionManager);
    }
}

