/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.v40.messaging.request;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.protocol.common.bookmark.Bookmark;
import org.neo4j.bolt.protocol.common.message.AccessMode;
import org.neo4j.bolt.protocol.v40.messaging.request.TransactionInitiatingMessage;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

public class RunMessage
extends TransactionInitiatingMessage {
    public static final byte SIGNATURE = 16;
    private final String statement;
    private final MapValue params;

    public RunMessage(String statement) {
        this(statement, VirtualValues.EMPTY_MAP);
    }

    public RunMessage(String statement, MapValue params) {
        this(statement, params, VirtualValues.EMPTY_MAP);
    }

    public RunMessage(String statement, MapValue params, MapValue meta) {
        this(statement, params, meta, List.of(), null, AccessMode.WRITE, Map.of(), "");
    }

    public RunMessage(String statement, MapValue params, MapValue meta, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata, String databaseName) {
        super(meta, bookmarks, txTimeout, accessMode, txMetadata, databaseName);
        this.statement = statement;
        this.params = params;
    }

    public String statement() {
        return this.statement;
    }

    public MapValue params() {
        return this.params;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RunMessage that = (RunMessage)o;
        return Objects.equals(this.statement, that.statement) && Objects.equals(this.params, that.params);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.statement, this.params);
    }

    public String toString() {
        return "RUN \"" + this.statement + "\", " + this.params + ", " + this.meta();
    }
}

