/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.transaction;

import java.time.Clock;
import java.util.Arrays;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.bolt.protocol.common.transaction.ExecutionPlanConverter;
import org.neo4j.bolt.protocol.common.transaction.result.AdaptingBoltQuerySubscriber;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.QueryStatistics;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.util.Preconditions;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

public abstract class AbstractCypherAdapterStream
implements BoltResult {
    private static final String TYPE = "type";
    private static final String STATS = "stats";
    private static final String PROFILE = "profile";
    private static final String PLAN = "plan";
    private static final String NOTIFICATIONS = "notifications";
    private static final TextValue READ_ONLY = Values.utf8Value((byte[])new byte[]{114});
    private static final TextValue READ_WRITE = Values.utf8Value((byte[])new byte[]{114, 119});
    private static final TextValue WRITE = Values.utf8Value((byte[])new byte[]{119});
    private static final TextValue SCHEMA_WRITE = Values.utf8Value((byte[])new byte[]{115});
    private final QueryExecution queryExecution;
    private final String[] fieldNames;
    protected final Clock clock;
    private final AdaptingBoltQuerySubscriber querySubscriber;
    private static final Long STREAM_UNLIMITED_BATCH_SIZE = Long.MAX_VALUE;

    public AbstractCypherAdapterStream(QueryExecution queryExecution, AdaptingBoltQuerySubscriber querySubscriber, Clock clock) {
        this.queryExecution = queryExecution;
        this.fieldNames = queryExecution.fieldNames();
        this.querySubscriber = querySubscriber;
        this.clock = clock;
    }

    @Override
    public void close() {
        this.queryExecution.cancel();
    }

    @Override
    public String[] fieldNames() {
        return this.fieldNames;
    }

    @Override
    public boolean handleRecords(BoltResult.RecordConsumer recordConsumer, long size) throws Throwable {
        long start = this.clock.millis();
        this.querySubscriber.setRecordConsumer(recordConsumer);
        boolean hasMore = true;
        if (size == -1L) {
            while (hasMore) {
                this.queryExecution.request(STREAM_UNLIMITED_BATCH_SIZE.longValue());
                hasMore = this.queryExecution.await();
            }
        } else {
            this.queryExecution.request(size);
            hasMore = this.queryExecution.await();
        }
        this.querySubscriber.assertSucceeded();
        if (!hasMore) {
            this.addRecordStreamingTime(this.clock.millis() - start, recordConsumer);
            this.addDatabaseName(recordConsumer);
            this.addMetadata(this.querySubscriber.queryStatistics(), recordConsumer);
        }
        return hasMore;
    }

    @Override
    public boolean discardRecords(BoltResult.DiscardingRecordConsumer consumer, long size) throws Throwable {
        Preconditions.checkArgument((size == -1L ? 1 : 0) != 0, (String)("Currently it is only supported to discard ALL records, but it was requested to discard " + size));
        if (this.queryExecution.executionType().queryType() == QueryExecutionType.QueryType.READ_ONLY) {
            long start = this.clock.millis();
            this.queryExecution.cancel();
            this.queryExecution.await();
            this.addRecordStreamingTime(this.clock.millis() - start, consumer);
            this.addMetadata(QueryStatistics.EMPTY, consumer);
            return false;
        }
        return this.handleRecords(consumer, size);
    }

    protected abstract void addDatabaseName(BoltResult.RecordConsumer var1);

    protected abstract void addRecordStreamingTime(long var1, BoltResult.RecordConsumer var3);

    private void addMetadata(QueryStatistics statistics, BoltResult.RecordConsumer recordConsumer) {
        Iterable notifications;
        QueryExecutionType qt = this.queryExecution.executionType();
        recordConsumer.addMetadata(TYPE, (AnyValue)AbstractCypherAdapterStream.queryTypeCode(qt.queryType()));
        this.addQueryStatistics(statistics, recordConsumer);
        if (qt.requestedExecutionPlanDescription()) {
            ExecutionPlanDescription rootPlanTreeNode = this.queryExecution.executionPlanDescription();
            String metadataFieldName = rootPlanTreeNode.hasProfilerStatistics() ? PROFILE : PLAN;
            recordConsumer.addMetadata(metadataFieldName, (AnyValue)ExecutionPlanConverter.convert(rootPlanTreeNode));
        }
        if ((notifications = this.queryExecution.getNotifications()).iterator().hasNext()) {
            recordConsumer.addMetadata(NOTIFICATIONS, AbstractCypherAdapterStream.convertNotifications(notifications));
        }
    }

    private void addQueryStatistics(QueryStatistics statistics, BoltResult.RecordConsumer recordConsumer) {
        if (statistics.containsUpdates()) {
            MapValue stats = this.queryStats(statistics).build();
            recordConsumer.addMetadata(STATS, (AnyValue)stats);
        } else if (statistics.containsSystemUpdates()) {
            MapValue stats = this.systemQueryStats(statistics).build();
            recordConsumer.addMetadata(STATS, (AnyValue)stats);
        }
    }

    public String toString() {
        return "CypherAdapterStream{delegate=" + this.queryExecution + ", fieldNames=" + Arrays.toString(this.fieldNames) + "}";
    }

    protected MapValueBuilder queryStats(QueryStatistics queryStatistics) {
        MapValueBuilder builder = new MapValueBuilder();
        AbstractCypherAdapterStream.addIfNonZero(builder, "nodes-created", queryStatistics.getNodesCreated());
        AbstractCypherAdapterStream.addIfNonZero(builder, "nodes-deleted", queryStatistics.getNodesDeleted());
        AbstractCypherAdapterStream.addIfNonZero(builder, "relationships-created", queryStatistics.getRelationshipsCreated());
        AbstractCypherAdapterStream.addIfNonZero(builder, "relationships-deleted", queryStatistics.getRelationshipsDeleted());
        AbstractCypherAdapterStream.addIfNonZero(builder, "properties-set", queryStatistics.getPropertiesSet());
        AbstractCypherAdapterStream.addIfNonZero(builder, "labels-added", queryStatistics.getLabelsAdded());
        AbstractCypherAdapterStream.addIfNonZero(builder, "labels-removed", queryStatistics.getLabelsRemoved());
        AbstractCypherAdapterStream.addIfNonZero(builder, "indexes-added", queryStatistics.getIndexesAdded());
        AbstractCypherAdapterStream.addIfNonZero(builder, "indexes-removed", queryStatistics.getIndexesRemoved());
        AbstractCypherAdapterStream.addIfNonZero(builder, "constraints-added", queryStatistics.getConstraintsAdded());
        AbstractCypherAdapterStream.addIfNonZero(builder, "constraints-removed", queryStatistics.getConstraintsRemoved());
        return builder;
    }

    protected MapValueBuilder systemQueryStats(QueryStatistics queryStatistics) {
        MapValueBuilder builder = new MapValueBuilder();
        AbstractCypherAdapterStream.addIfNonZero(builder, "system-updates", queryStatistics.getSystemUpdates());
        return builder;
    }

    protected static void addIfNonZero(MapValueBuilder builder, String name, int count) {
        if (count > 0) {
            builder.add(name, (AnyValue)Values.intValue((int)count));
        }
    }

    protected static void addIfTrue(MapValueBuilder builder, String name, boolean value) {
        if (value) {
            builder.add(name, (AnyValue)Values.booleanValue((boolean)true));
        }
    }

    private static TextValue queryTypeCode(QueryExecutionType.QueryType queryType) {
        switch (queryType) {
            case READ_ONLY: {
                return READ_ONLY;
            }
            case READ_WRITE: {
                return READ_WRITE;
            }
            case WRITE: {
                return WRITE;
            }
            case SCHEMA_WRITE: 
            case DBMS: {
                return SCHEMA_WRITE;
            }
        }
        throw new IllegalStateException(String.format("%s is not a known query type", queryType));
    }

    private static AnyValue convertNotifications(Iterable<Notification> notifications) {
        ListValueBuilder listValueBuilder = ListValueBuilder.newListBuilder();
        for (Notification notification : notifications) {
            InputPosition pos = notification.getPosition();
            boolean includePosition = !pos.equals((Object)InputPosition.empty);
            int size = includePosition ? 5 : 4;
            MapValueBuilder builder = new MapValueBuilder(size);
            builder.add("code", (AnyValue)Values.utf8Value((String)notification.getCode()));
            builder.add("title", (AnyValue)Values.utf8Value((String)notification.getTitle()));
            builder.add("description", (AnyValue)Values.utf8Value((String)notification.getDescription()));
            builder.add("severity", (AnyValue)Values.utf8Value((String)notification.getSeverity().toString()));
            if (includePosition) {
                builder.add("position", (AnyValue)VirtualValues.map((String[])new String[]{"offset", "line", "column"}, (AnyValue[])new AnyValue[]{Values.intValue((int)pos.getOffset()), Values.intValue((int)pos.getLine()), Values.intValue((int)pos.getColumn())}));
            }
            listValueBuilder.add((AnyValue)builder.build());
        }
        return listValueBuilder.build();
    }
}

