/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.writer;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.bolt.protocol.io.pipeline.WriterContext;
import org.neo4j.bolt.protocol.io.writer.StructWriter;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.virtual.MapValue;

@Deprecated(since="5.0", forRemoval=true)
public final class LegacyStructWriter
implements StructWriter {
    private static final LegacyStructWriter INSTANCE = new LegacyStructWriter();

    private LegacyStructWriter() {
    }

    public static StructWriter getInstance() {
        return INSTANCE;
    }

    @Override
    public void writeDateTime(WriterContext ctx, ZonedDateTime zonedDateTime) {
        Objects.requireNonNull(zonedDateTime, "dateTime cannot be null");
        long epochSecondLocal = zonedDateTime.toLocalDateTime().toEpochSecond(ZoneOffset.UTC);
        ZoneId zone = zonedDateTime.getZone();
        if (zone instanceof ZoneOffset) {
            StructType.DATE_TIME_LEGACY.writeHeader(ctx);
            ctx.buffer().writeInt(epochSecondLocal).writeInt(zonedDateTime.getNano()).writeInt(zonedDateTime.getOffset().getTotalSeconds());
            return;
        }
        StructType.DATE_TIME_ZONE_ID_LEGACY.writeHeader(ctx);
        ctx.buffer().writeInt(epochSecondLocal).writeInt(zonedDateTime.getNano()).writeString(zone.getId());
    }

    @Override
    public void writeNode(WriterContext ctx, String elementId, long nodeId, TextArray labels, MapValue properties, boolean isDeleted) {
        StructType.NODE.writeLegacyHeader(ctx);
        List stringLabels = StreamSupport.stream(labels.spliterator(), false).map(label -> ((TextValue)label).stringValue()).collect(Collectors.toList());
        ctx.buffer().writeInt(nodeId).writeList(stringLabels, PackstreamBuf::writeString);
        ctx.writeValue((AnyValue)properties);
    }

    @Override
    public void writeRelationship(WriterContext ctx, String elementId, long relId, String startNodeElementId, long startNodeId, String endNodeElementId, long endNodeId, TextValue type, MapValue properties, boolean isDeleted) {
        StructType.RELATIONSHIP.writeLegacyHeader(ctx);
        ctx.buffer().writeInt(relId).writeInt(startNodeId).writeInt(endNodeId).writeString(type.stringValue());
        ctx.writeValue((AnyValue)properties);
    }

    @Override
    public void writeUnboundRelationship(WriterContext ctx, String elementId, long relId, String type, MapValue properties) {
        StructType.UNBOUND_RELATIONSHIP.writeLegacyHeader(ctx);
        ctx.buffer().writeInt(relId).writeString(type);
        ctx.writeValue((AnyValue)properties);
    }
}

