/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.io.reader.legacy;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.zone.ZoneRulesException;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.packstream.error.reader.PackstreamReaderException;
import org.neo4j.packstream.error.struct.IllegalStructArgumentException;
import org.neo4j.packstream.error.struct.IllegalStructSizeException;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.values.storable.DateTimeValue;

@Deprecated(forRemoval=true, since="5.0")
public final class LegacyDateTimeZoneIdReader<CTX>
implements StructReader<CTX, DateTimeValue> {
    private static final LegacyDateTimeZoneIdReader<?> INSTANCE = new LegacyDateTimeZoneIdReader();

    private LegacyDateTimeZoneIdReader() {
    }

    public static <CTX> LegacyDateTimeZoneIdReader<CTX> getInstance() {
        return INSTANCE;
    }

    @Override
    public short getTag() {
        return StructType.DATE_TIME_ZONE_ID_LEGACY.getTag();
    }

    @Override
    public DateTimeValue read(CTX ctx, PackstreamBuf buffer, StructHeader header) throws PackstreamReaderException {
        LocalDateTime localDateTime;
        ZoneId zoneId;
        if (header.length() != 3L) {
            throw new IllegalStructSizeException(3L, header.length());
        }
        long epochSecond = buffer.readInt();
        long nanos = buffer.readInt();
        String zoneName = buffer.readString();
        if (nanos > Integer.MAX_VALUE || nanos < Integer.MIN_VALUE) {
            throw IllegalStructArgumentException.wrongTypeForFieldNameOrOutOfRange("nanoseconds", "INTEGER", Integer.MIN_VALUE, Integer.MAX_VALUE, nanos, "Value exceeds bounds");
        }
        try {
            Instant instant = Instant.ofEpochSecond(epochSecond, nanos);
            zoneId = ZoneId.of(zoneName);
            localDateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        }
        catch (ZoneRulesException ex) {
            throw new IllegalStructArgumentException("tz_id", String.format("Illegal zone identifier: \"%s\"", zoneName), (Throwable)ex);
        }
        catch (ArithmeticException | DateTimeException ex) {
            throw IllegalStructArgumentException.invalidTemporalComponent("seconds", epochSecond, nanos, ex);
        }
        return DateTimeValue.datetime((ZonedDateTime)ZonedDateTime.of(localDateTime, zoneId));
    }
}

