/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.protocol.common.signal.StateSignal;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.packstream.signal.FrameSignal;

public class KeepAliveHandler
extends IdleStateHandler {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(KeepAliveHandler.class);
    private final Log log;
    private final boolean legacyMode;
    private boolean processing;
    private boolean streaming;

    public KeepAliveHandler(boolean legacyMode, long writerIdleTimeSeconds, InternalLogProvider logging) {
        super(0L, writerIdleTimeSeconds, 0L, TimeUnit.MILLISECONDS);
        this.legacyMode = legacyMode;
        this.log = logging.getLog(KeepAliveHandler.class);
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        if (this.processing || this.streaming && this.legacyMode) {
            ctx.writeAndFlush((Object)FrameSignal.NOOP);
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof StateSignal) {
            StateSignal signal = (StateSignal)((Object)msg);
            switch (signal) {
                case BEGIN_JOB_PROCESSING: {
                    this.processing = true;
                    if (this.legacyMode) break;
                    this.log.debug("[%s] Engaging client liveliness check", new Object[]{ctx.channel().remoteAddress()});
                    break;
                }
                case END_JOB_PROCESSING: {
                    this.processing = false;
                    if (this.legacyMode) break;
                    this.log.debug("[%s] Disengaging client liveliness check", new Object[]{ctx.channel().remoteAddress()});
                    break;
                }
                case ENTER_STREAMING: {
                    this.streaming = true;
                    if (!this.legacyMode) break;
                    this.log.debug("[%s] Engaging legacy client liveliness check", new Object[]{ctx.channel().remoteAddress()});
                    break;
                }
                case EXIT_STREAMING: {
                    this.streaming = false;
                    if (!this.legacyMode) break;
                    this.log.debug("[%s] Disengaging legacy client liveliness check", new Object[]{ctx.channel().remoteAddress()});
                    break;
                }
                default: {
                    return;
                }
            }
        }
        super.write(ctx, msg, promise);
    }
}

