/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.connector.accounting.error;

import java.time.Clock;
import org.neo4j.bolt.protocol.common.connector.accounting.error.CircuitBreaker;
import org.neo4j.bolt.protocol.common.connector.accounting.error.ErrorAccountant;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public final class CircuitBreakerErrorAccountant
implements ErrorAccountant {
    private static final long REPEAT_LOG_LINE_MILLIS = 300000L;
    private final CircuitBreaker networkAbortCircuitBreaker;
    private final CircuitBreaker threadStarvationCircuitBreaker;
    private final Log userLog;

    public CircuitBreakerErrorAccountant(long networkAbortThreshold, long networkAbortSampleDurationMillis, long networkAbortResetDurationMillis, long threadStarvationThreshold, long threadStarvationSampleDurationMillis, long threadStarvationResetDurationMillis, Clock clock, LogService logging) {
        this.networkAbortCircuitBreaker = networkAbortThreshold > 0L ? new CircuitBreaker(networkAbortThreshold, networkAbortSampleDurationMillis, networkAbortResetDurationMillis, new NetworkAbortCircuitBreakerListener(networkAbortThreshold, networkAbortSampleDurationMillis), clock) : null;
        this.threadStarvationCircuitBreaker = threadStarvationThreshold > 0L ? new CircuitBreaker(threadStarvationThreshold, threadStarvationSampleDurationMillis, threadStarvationResetDurationMillis, new ThreadStarvationCircuitBreakerListener(threadStarvationThreshold, threadStarvationSampleDurationMillis), clock) : null;
        this.userLog = logging.getUserLog(ErrorAccountant.class);
    }

    @Override
    public void notifyNetworkAbort(Connection connection, Throwable cause) {
        if (this.networkAbortCircuitBreaker == null) {
            this.userLog.warn("[" + connection.id() + "] Terminating connection due to network error", cause);
            return;
        }
        this.userLog.debug("[" + connection.id() + "] Terminating connection due to network error", cause);
        this.networkAbortCircuitBreaker.increment();
    }

    @Override
    public void notifyThreadStarvation(Connection connection, Throwable cause) {
        if (this.threadStarvationCircuitBreaker == null) {
            this.userLog.error("[%s] Unable to schedule for execution since there are no available threads to serve it at the moment.", new Object[]{connection.id()});
            return;
        }
        this.userLog.debug("[%s] Unable to schedule for execution since there are no available threads to serve it at the moment.", new Object[]{connection.id()});
        this.threadStarvationCircuitBreaker.increment();
    }

    private class NetworkAbortCircuitBreakerListener
    extends ContinuallyLoggingCircuitBreakerListener {
        private final long threshold;
        private final long window;

        public NetworkAbortCircuitBreakerListener(long threshold, long window) {
            this.threshold = threshold;
            this.window = window;
        }

        @Override
        public void onTripped() {
            CircuitBreakerErrorAccountant.this.userLog.error("Increase in network aborts detected (more than %d network related connection aborts over a period of %d ms) - This may indicate an issue with the network environment or an overload condition", new Object[]{this.threshold, this.window});
        }

        @Override
        protected void doOnContinue() {
            CircuitBreakerErrorAccountant.this.userLog.error("Network abort rate remains increased (more than %d network related connection aborts over a period of %d ms) - This may indicate an issue with the network environment or an overload condition", new Object[]{this.threshold, this.window});
        }

        @Override
        public void onReset() {
            super.onReset();
            CircuitBreakerErrorAccountant.this.userLog.info("Network abort rate has normalized");
        }
    }

    private class ThreadStarvationCircuitBreakerListener
    extends ContinuallyLoggingCircuitBreakerListener {
        private final long threshold;
        private final long window;

        public ThreadStarvationCircuitBreakerListener(long threshold, long window) {
            this.threshold = threshold;
            this.window = window;
        }

        @Override
        public void onTripped() {
            CircuitBreakerErrorAccountant.this.userLog.error("Increase in thread starvation events detected (%d events over a period of %d ms) - This may indicate an overload condition", new Object[]{this.threshold, this.window});
        }

        @Override
        protected void doOnContinue() {
            CircuitBreakerErrorAccountant.this.userLog.error("Thread starvation event rate remains increased (more than %d events over a period of %d ms) - This may indicate an overload condition", new Object[]{this.threshold, this.window});
        }

        @Override
        public void onReset() {
            super.onReset();
            CircuitBreakerErrorAccountant.this.userLog.info("Thread starvation event rate has normalized");
        }
    }

    private static abstract class ContinuallyLoggingCircuitBreakerListener
    implements CircuitBreaker.Listener {
        private volatile long lastLogLine;

        private ContinuallyLoggingCircuitBreakerListener() {
        }

        @Override
        public void onContinue() {
            long now = System.currentTimeMillis();
            if (this.lastLogLine == 0L || now - this.lastLogLine < 300000L) {
                return;
            }
            this.lastLogLine = now;
            this.doOnContinue();
        }

        @Override
        public void onReset() {
            this.lastLogLine = 0L;
        }

        protected abstract void doOnContinue();
    }
}

