/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation.message;

import io.netty.buffer.ByteBufAllocator;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.bolt.negotiation.util.BitMask;
import org.neo4j.util.Preconditions;

public enum ProtocolCapability {
    HANDSHAKE_V2,
    FABRIC(1);

    private final int networkIndex;
    private static final int maxNetworkIndex;
    private static final ProtocolCapability[] networkIndexMap;

    private ProtocolCapability(int networkIndex) {
        if (networkIndex == 0 || networkIndex < -1) {
            throw new IllegalArgumentException("Network index must be positive");
        }
        this.networkIndex = networkIndex;
    }

    private ProtocolCapability() {
        this(-1);
    }

    public static Optional<ProtocolCapability> byNetworkIndex(int networkIndex) {
        Preconditions.requirePositive((int)networkIndex);
        if (networkIndex > networkIndexMap.length) {
            return Optional.empty();
        }
        return Optional.ofNullable(networkIndexMap[networkIndex - 1]);
    }

    public static BitMask toBitMask(ByteBufAllocator alloc, Set<ProtocolCapability> capabilities) {
        BitMask mask = new BitMask(alloc, maxNetworkIndex);
        for (ProtocolCapability capability : capabilities) {
            if (capability.networkIndex < 1) {
                throw new IllegalArgumentException("Cannot encode implicit capability " + String.valueOf((Object)capability) + " to BitMask");
            }
            mask.set(capability.networkIndex - 1, true);
        }
        return mask;
    }

    public static Set<ProtocolCapability> fromBitMask(BitMask mask) {
        EnumSet<ProtocolCapability> capabilities = EnumSet.noneOf(ProtocolCapability.class);
        for (int i = 0; i < mask.length() && i < networkIndexMap.length; ++i) {
            ProtocolCapability capability;
            if (!mask.get(i) || (capability = networkIndexMap[i]) == null) continue;
            capabilities.add(capability);
        }
        return capabilities;
    }

    static {
        maxNetworkIndex = Stream.of(ProtocolCapability.values()).mapToInt(capability -> capability.networkIndex).filter(it -> it > 0).max().orElse(-1);
        ProtocolCapability[] map = new ProtocolCapability[maxNetworkIndex];
        for (ProtocolCapability capability2 : ProtocolCapability.values()) {
            if (capability2.networkIndex <= 0) continue;
            map[capability2.networkIndex - 1] = capability2;
        }
        networkIndexMap = map;
    }
}

